function [idx_info] = vb_util_get_bit_on_list(bit_list, bit_len)
% get ON bit indices ALL and BEGINNING and ENDING
% [usage]
%   [idx_info] = vb_util_get_bit_on_list(bit_list, bit_len)
% [input]
%    bit_list: <required> bit list [1 x N_sample]
%    bit_len : <optional> length of data bit [DEFAULT_BIT_LEN]
% [output]
%   idx_info : <struct> sample numbers information of trigger
%            :  - all_idx : list of index of "ON" bit
%            :  - beg_idx : index that "ON" bit begins
%            :  - end_idx : index that "ON" bit breathe
% [note]
%   DEFAULT_BIT_LEN is defined in 'define_biosemi.m'
% [history]
%   2007-01-11 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('bit_list', 'var'), bit_list = []; end;
if ~exist('bit_len', 'var'), bit_len = []; end;
[bit_list, bit_len, data_len] = inner_check_arguments(bit_list, bit_len);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
idx_info = [];
beg_idx = [];
end_idx = [];

all_idx = find(bit_list == 1);

if ~isempty(all_idx)
    
  prev_idx = all_idx(1);
  beg_idx = all_idx(1);
  for nb = 2:size(all_idx,2)
    if all_idx(nb) ~= prev_idx + 1
      beg_idx = [beg_idx, all_idx(nb)];
      if nb > 1
        end_idx = [end_idx, all_idx(nb-1)];
      end
    end
    prev_idx = all_idx(nb);
  end
end

idx_info.all_idx = all_idx;
idx_info.beg_idx = beg_idx;
idx_info.end_idx = end_idx;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [bit_list, bit_len, data_len] = ...
  inner_check_arguments(bit_list, bit_len)

vb_define_device;

if isempty(bit_list)
  error('bit_list is a required parameter');
end

if isempty(bit_len)
  bit_len = DEFAULT_BIT_LEN;
end

% arrange to [1 x N]
bit_list = vb_util_arrange_list(bit_list, 1);
data_len = size(bit_list,2);
%
% --- end of inner_check_arguments()

% --- END OF FILE --- %
