function axisends = vb_axisends_set(axisends, ...
  type_tag, axis_tag, begin_val, end_val)
% set axisends value of both ends
% [usage]
%   axisends = vb_axisends_set(axisends, type_tag, axis_tag, begin_val, end_val)
% [input]
%    axisends : <required> <struct>
%             :  You can see this structure below (output).
%    type_tag : <required> tag of setting type. case-insensitive
%             :  'ORIGINAL' : original begin and end value
%             :    'SLIDER' : base begin and end value for slider
%             :  'PREVIOUS' : previous begin and end value
%    axis_tag : <required> tag of axis type ('X' or 'Y'). case-insensitive
%   begin_val : value of begin
%     end_val : value of end
% [output]
%    axisends : <struct> both ends set. its fields are as follows
%             :   original_x <both_ends>
%             :   slider_x   <both_ends>
%             :   previous_x <both_ends>
%             :   original_y <both_ends>
%             :   slider_y   <both_ends>
%             :   previous_y <both_ends>
%             :
%             :   <struct : both_ends>
%             :      begin
%             :      end
% [note]
% 
% [history]
%   2007-02-19 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('axisends',  'var'),  axisends = []; end;
if ~exist('type_tag',  'var'),  type_tag = []; end;
if ~exist('axis_tag',  'var'),  axis_tag = []; end;
if ~exist('begin_val', 'var'), begin_val = []; end;
if ~exist('end_val',   'var'),   end_val = []; end;
[axisends, type_tag, axis_tag, begin_val, end_val] = ...
  inner_check_arguments(axisends, type_tag, axis_tag, begin_val, end_val);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
switch type_tag
  case  'ORIGINAL'
    switch axis_tag
      case  'X'
        axisends.original_x.begin = begin_val;
        axisends.original_x.end   = end_val;
      case  'Y'
        axisends.original_y.begin = begin_val;
        axisends.original_y.end   = end_val;
    end

  case  'SLIDER'
    switch axis_tag
      case  'X'
        axisends.slider_x.begin = begin_val;
        axisends.slider_x.end   = end_val;
      case  'Y'
        axisends.slider_y.begin = begin_val;
        axisends.slider_y.end   = end_val;
    end
    
  case  'PREVIOUS'
    switch axis_tag
      case  'X'
        axisends.previous_x.begin = begin_val;
        axisends.previous_x.end   = end_val;
      case  'Y'
        axisends.previous_y.begin = begin_val;
        axisends.previous_y.end   = end_val;
    end
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [axisends, type_tag, axis_tag, begin_val, end_val] = ...
  inner_check_arguments(axisends, type_tag, axis_tag, begin_val, end_val)

% need not check axisends
% if isempty(axisends) ...

if isempty(type_tag),  error('type_tag is a required parameter'); end;
if isempty(axis_tag),  error('axis_tag is a required parameter'); end;
if isempty(begin_val), error('begin_val is a required paramter'); end;
if isempty(end_val),   error('end_val is a required paramter');   end;

if begin_val > end_val
  tmp_begin_val = begin_val;
  begin_val = end_val;
  end_val = tmp_begin_val;
end

type_tag = upper(type_tag);
axis_tag = upper(axis_tag);

if ~strcmp(type_tag, 'ORIGINAL') ...
    && ~strcmp(type_tag, 'SLIDER') ...
    && ~strcmp(type_tag, 'PREVIOUS')
    error('unknown type_tag : %s', type_tag);
end

if ~strcmp(axis_tag, 'X') && ~strcmp(axis_tag, 'Y')
  error('unknown axis_tag : %s', axis_tag);
end

%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
