function	[h,x] = vb_merge_histgram_detail(h1,x1,h2,x2)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%h(n) = num of data in x(n) +- dx/2, dx =  x(2)-x(1)
N1 = length(x1);
N2 = length(x2);
d1 = x1(2) - x1(1);
d2 = x2(2) - x2(1);

if max(x1)==max(x2) && N1==N2
	h = h1 + h2;
	x = x1;
else
	XMAX = max(max(x1),max(x2));
	XMIN = min(min(x1),min(x2));
	dx = min(d1,d2);
	N  = ceil((XMAX - XMIN)/dx)+1;
	h  = zeros(N,1);
	x  = (0:N-1)*dx + XMIN;
	
	for n=1:N
		% n-th bin for new histgram h(n)
		xmax = (x(n) + dx/2);
		xmin = (x(n) - dx/2);
		
		% find h1-bin included in  [xmin xmax] 
		ix = find( x1 >= xmin & x1 < xmax);
		if ~isempty(ix)
			for j=1:length(ix)
				m  = ix(j); 
				xx = x1(m); % mid point of h1(m)
				% upper % lower bound of h1(m) in [xmin xmax] 
				xup  = min(xx + d1/2 , xmax);
				xlow = max(xx - d1/2 , xmin);
				% add number of h1(m) which is included in [xmin xmax]
				h(n) = h(n) + h1(m) * (xup - xlow)/d1;
			end
		end
		
		% find h2-bin included in  [xmin xmax] 
		ix = find( x2 >= xmin & x2 < xmax);
		if ~isempty(ix)
			for j=1:length(ix)
				m  = ix(j); 
				xx = x2(m); % mid point of h2(m)
				% upper % lower bound of h2(m) in [xmin xmax] 
				xup  = min(xx + d2/2 , xmax);
				xlow = max(xx - d2/2 , xmin);
				% add number of h2(m) which is included in [xmin xmax]
				h(n) = h(n) + h2(m) * (xup - xlow)/d2;
			end
		end
	end
end

