function fileinfo = vb_fileinfo_active_field_convert_to(format, fileinfo, data_file)
% convert fileinfo active part format from new to old or old to new.
% * Think not to use this function as possible, please use new fields.
%    fileinfo.ActiveChannel
%    fileinfo.ActiveTrial.
%
% [Usage]
%    fileinfo = vb_fileinfo_active_field_convert_to(format, fileinfo, data_file);
%
% [Input]
%    format     : converted format. [string]
%                 = 'new' : old format to new format.
%                 = 'old' : new format to old format.
%    fileinfo   : fileinfo struct.
%    data_file  : fileinfo file.
%
% [Output]
%      fileinfo : converted fileinfo.
%

%
% --- Previous check
%
if ~exist('format', 'var')
    error('format is required parameter.');
end
if ~exist('fileinfo', 'var')
    error('fileinfo is required parameter.');
end
if ~exist('data_file', 'var')
    error('fileinfo is required parameter.');
end
if exist(data_file, 'file') ~= 2
    error('Specified data_file not found.');
end

%
% --- Main procedure
%
if isfield(fileinfo, 'channel_id')
    current_format = 'old';
elseif isfield(fileinfo, 'ActiveChannel')
    current_format = 'new';
end

% No need to convert
if strcmp(current_format, format), return; end

% convert
ch_info = vb_load_channel_info(data_file);

switch(format)
    case 'old'
        % new to old
        fileinfo.channel_id = ch_info.ID(fileinfo.ActiveChannel ~= 0);
        fileinfo.act_trial  = find(fileinfo.ActiveTrial ~= 0);

        % remove new field
        fileinfo = rmfield(fileinfo, 'ActiveChannel');
        fileinfo = rmfield(fileinfo, 'ActiveTrial');

    case 'new'
        % old to new
        ix = vb_util_get_index(ch_info.ID, fileinfo.channel_id);
        fileinfo.ActiveChannel = zeros(length(fileinfo.Nchannel), 1);
        fileinfo.ActiveChannel(ix) = 1;
        fileinfo.ActiveTrial = zeros(length(fileinfo.Ntotal), 1);
        fileinfo.ActiveTrial(fileinfo.act_trial) = 1;
        % remove new field
        fileinfo = rmfield(fileinfo, 'channel_id');
        fileinfo = rmfield(fileinfo, 'act_trial');

    otherwise
        error('Invalid format was specified.');
end

