function mri_key = vb_posfile_load_mrikey(posfile)
% read and return MRI KEY from POS-MAT file
% [usage]
%   mri_key = vb_posfile_load_mrikey(posfile)
% [input]
%   posfile : <required> <<file>> POS-MAT file
% [output]
%   mri_key : MRI hash key
% [note]
%
% [history]
%   2008-03-12 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('posfile', 'var'), posfile = ''; end
[posfile] = inner_check_arguments(posfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
mri_key = '';
load(posfile, 'mri_key');
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [posfile] = inner_check_arguments(posfile)
func_ = mfilename;
if isempty(posfile)
  error('(%s)posfile is a required parameter', func_);
end

if exist(posfile, 'file') ~= 2
  error('(%s)cannot find posfile: %s', func_, posfile);
end
return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
