function [tbl] = vb_define_description_table
% Define description table.
% Add common description here.
% [USAGE]
%    [tbl] = vb_define_description_table
% [OUT]
%    tbl : description table data
%
% [see]
%    vb_key_value_pair.m
%    vb_table_insert.m
%    vb_table_query_value.m


tbl = [];

% --- brain_file
key = 'brain_file';
value = sprintf('Cortical model file (.brain.mat)');
tbl = vb_table_insert(tbl, vb_key_value_pair(key, value));

% --- area_file
key = 'area_file';
value = sprintf('Cortical area file (.area.mat)');
tbl = vb_table_insert(tbl, vb_key_value_pair(key, value));

% --- act_file
key = 'act_file';
value = sprintf('Cortical activity file (.act.mat)');
tbl = vb_table_insert(tbl, vb_key_value_pair(key, value));

% --- current_file
key = 'current_file';
value = sprintf('Cortical current file (.curr.mat)');
tbl = vb_table_insert(tbl, vb_key_value_pair(key, value));

% --- tf_file
key = 'tf_file';
value = sprintf('Time frequency file (.tf.mat)');
tbl = vb_table_insert(tbl, vb_key_value_pair(key, value));

% --- current_mode
key = 'current_load_mode';
value = sprintf(['average :averaged current data is loaded.\n', ...
                 '    raw :specified single trial current data is loaded.']);
tbl = vb_table_insert(tbl, vb_key_value_pair(key, value));

% --- jpcp_current
key = 'jpcp_current';
value = '';
tbl = vb_table_insert(tbl, vb_key_value_pair(key, value));

% --- jpcp_timefreq
key = 'jpcp_timefreq';
value = '';
tbl = vb_table_insert(tbl, vb_key_value_pair(key, value));
