function cmp_result = vb_version_cmp(ver_str1,cmp_opr,ver_str2)
% Compare VBMEG version strings. 
%
% [syntax]
% [comparative_result] = vb_version(ver_str1,cmp_opr,ver_str2);
%
% [input]
% ver_str1: <<string>> VBMEG version string (e.g., '0.9-0.a.0'). 
% cmp_opr : <<string>> Comparative operator ('==', '~=', '<', '<=', '>'
%           or '>='). 
% ver_str2: <<string>> VBMEG version string (e.g., '0.9-0.a.0'). 
%
% [output]
% comparative_result: <<bool>> Return result of logical expression 
%                     'ver_str1 cmp_opr ver_str2'. 
%
% [example]
% 1st example return true because 0.9>0.7. 
% >> vb_version_cmp('0.9-0.a.0','>','0.7')
% 
% ans =
%
%      1
%
% >>
%
% 2nd example return true because the 3rd component of version string
% (commonly 'a', alpha or 'b', beta). See note. 
% >> vb_version_cmp('0.9-0','==','0.9-0.a')
%
% ans =
%
%      1
%
% >>
%
% [note]
% If version string is imcomplete (e.g., '0.9-0'), remained version
% numbers will be set to those of the compared version string. In the
% second example, the first version string does not have alpha/beta
% character (e.g., 'a' or 'b'), then the first one is interpreted as
% '0.9-0.a'; 'a' comes from the second version string. 
% 
% @see vb_version.m
%
% [history]
% 2010-12-07 taku-y
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~ischar(ver_str1) || ~ischar(ver_str2)
  error('version string should be string.');
end;

% Scan version string and check error
[ver1,count1,errmsg1,nextindex1] = sscanf(ver_str1, '%lf-%d.%c.%d');
[ver2,count2,errmsg2,nextindex2] = sscanf(ver_str2, '%lf-%d.%c.%d');

if ~isempty(errmsg1), 
  error(['Input version string is invalid at ' num2str(nextindex1) ...
         ' : ' ver_str1]);
end;

if ~isempty(errmsg2), 
  error(['Input version string is invalid at ' num2str(nextindex2) ...
         ' : ' ver_str2]);
end;

% Make version string valid
input_ver1 = zeros(4,1);
input_ver2 = zeros(4,1);

if count1>count2, 
  for i=1:count2
    input_ver1(i) = double(ver1(i));
    input_ver2(i) = double(ver2(i));
  end;
  
  for i=count2+1:count1
    input_ver1(i) = double(ver1(i));
    input_ver2(i) = double(ver1(i));
  end;
else
  for i=1:count1
    input_ver1(i) = double(ver1(i));
    input_ver2(i) = double(ver2(i));
  end;
  
  for i=count1+1:count2
    input_ver1(i) = double(ver2(i));
    input_ver2(i) = double(ver2(i));
  end;
end;

% Compare version strings
[cmp_result] = compare_version(cmp_opr,input_ver1,input_ver2);

return;

function [result] = compare_version(cmp_opr,lhs,rhs)

result = true;
count  = length(lhs);

% Compare
% lhs(1) lhs(2) lhs(3) lhs(4)
%   |      |      |      |
% rhs(1) rhs(2) rhs(3) rhs(4)
% ------------> compare direction
%  k==1   k==2   k==3   k==4
for k=1:count
    if (lhs(k) == rhs(k)) && (k ~= count)
        % Ǿ̷夫鲼ظä1夺ĥå
        % ƱͤξϡҤȤĲηȽǤꤹ롣
        % ꤷƺǲ̷ޤǹԤäϡ
        % ƱͤǤⲼӱ黻Ҥˤӷ̤.
        continue;
    else
        % ӱ黻Ҥˤ.
        result = eval(['lhs(k)' cmp_opr 'rhs(k)']);
        return;
    end;
end;

return;
