function [match_idx] = ...
  vb_util_get_matching_label_index(base_labels, target_labels)
% return matching index numbers on base label list
% [usage]
%   match_idx = vb_util_get_matching_label_index(base_labels, target_labels)
% [input]
%     base_labels : <required> base label list - cell array {N x 1}
%   target_labels : <required> target label list - cell array  {N x 1}
% [output]
%   match_idx : index numbers on base_labels (N x 1)
% [note]
%
% [see also]
%   vb_util_get_index
%
% [history]
%   2011-07-28 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('base_labels', 'var'), base_labels = []; end
if ~exist('target_labels', 'var'), target_labels = []; end
[base_labels, target_labels] = ...
  inner_check_arguments(base_labels, target_labels);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
match_idx = [];
n_target = size(target_labels, 1);

for i_target = 1:n_target
  cur_idx = find(strcmp(base_labels, target_labels{i_target}) == 1);

  if isempty(cur_idx), continue; end

  match_idx = [match_idx;cur_idx];
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [base_labels, target_labels] = ...
  inner_check_arguments(base_labels, target_labels)

func_ = mfilename;

if isempty(base_labels)
  error('(%s)base_labels is a required parameter', func_);
end

if isempty(target_labels)
  error('(%s)target_labels is a required parameter', func_);
end

if ~iscell(base_labels)
  base_labels = {base_labels};
end

if ~iscell(target_labels)
  target_labels = {target_labels};
end

% re-arrange arrays
base_labels = vb_util_arrange_list(base_labels);
target_labels = vb_util_arrange_list(target_labels);
return;
%
% --- end of inner_check_arguments()

% --- END OF FILE --- %
