function [url_list] = vb_users_manual_url(caption_str)
% Retrieve url to access vbmeg_users_manual.htm by specifying keyword.
% This function is used with vb_help_info_get.m
%
% [Input]
%     caption_str : string for search.
%
% [Output]
%    url_list : url to vbmeg_users_manual.htm
%
% [see]
%    vb_users_manual_info_get.m
%
% [Example]
%    url_list = vb_users_manual_url('Data import');
%    web(url_list);
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('caption_str', 'var')
    error('caption_str should be specified.');
end


%
% --- Main Procedure
%
[caption_list, caption_url_list] = vb_users_manual_info_get;

ix = strmatch(caption_str, caption_list);
if isempty(ix)
    error('Invalid caption_str was specified.');
end
if length(ix) == 1
    url_list = caption_url_list{ix};
else
    url_list = caption_url_list(ix);
end
