function [caption_list, url_list] = vb_users_manual_info_get
% Read vbmeg_users_manual.html in the doc directory
% and gives caption to retrieve url to access the html file.
% This function is used with vb_help_url_get.m
% [see]
%    vb_users_manual_url.m
% 
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

vbmeg_dir = vb_get_file_parts(which('vbmeg.m'));
help_file = fullfile(vbmeg_dir, 'functions', 'doc', 'html', 'static', 'vbmeg_users_manual.html');

caption_list = cell(0);
url_list  = cell(0);

%
% --- Read help file
%
fid = fopen(help_file, 'rt');
if fid == -1
    error('Can not open users manual.');
end

contents = cell(0);
l = 1;
while(feof(fid) ~= 1)
   line = fgetl(fid);
   if is_toc_line(line);
       contents{l} = line;
       l = l+1;
   end
end
fclose(fid);

for k=1:length(contents)
    line = contents{k};
    [word, toc_id, add_line] = toc_get_info(line);
    if add_line
        line = [line, contents{k+1}];
        [word, toc_id, add_line] = toc_get_info(line);
        k = k+1;
    end
    caption_list{k} = word;
    url_list{k}     = [help_file, toc_id];
    %fprintf('word=%s toc_id=%s\n', word, toc_id);
end
caption_list = caption_list';
url_list     = url_list';

function [word, toc_id, add_line] = toc_get_info(line)
word    = '';
toc_id  = '';
if is_toc_line(line) == false
    return;
end
add_line = false;
%
try
pat = '.*href="(.*)"';
[tmp, tokens] = regexp(line, pat, 'match', 'tokens');
toc_id = tokens{1}{1};

pat = '[!>]*>[!<](*)<';
[tmp, tokens] = regexp(line, '.*href.*?>(.*?)<', 'match', 'tokens');
word = tokens{1}{1};
catch
   add_line = true;
end

function bool_value = is_toc_line(line)
% find href in contents
cond1 = strfind(line, 'href');
cond2 = strfind(line, '#');
cond3 = strfind(lower(line), 'toc');
if ~isempty(cond1) && ~isempty(cond2) && ~isempty(cond3)
    bool_value = true;
else
    bool_value = false;
end
