function index = vb_time_to_index(time,meg_info)
% Return sample number for given time (ms)
%
% --- Syntax
% index = vb_time_to_index(time,MEGinfo)
%
% --- History
% 2008-10-30 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

sample_freq     = vb_meginfo_get_sampling_frequency(meg_info);
Nsample         = vb_meginfo_get_sample_number(meg_info);
pretrigger      = vb_meginfo_get_pre_trigger(meg_info);

% sampling length(msec).
sampling_length = 1000/sample_freq;

% time list of sample points
sampling_point = -(sampling_length * pretrigger) : sampling_length : ...
    (sampling_length * (Nsample-pretrigger-1));

for k=1:length(time)
  if time(k) < min(sampling_point)
    time(k) = min(sampling_point);
  elseif time(k) > max(sampling_point)
    time(k) = max(sampling_point);
  end

  % Index of MEG data
  index(k) = min(find(sampling_point>=time(k)));
end
