function table = vb_table_insert(table, key_value)
% Insert key_value table.
% [USAGE]
%    table = vb_table_insert(table, key_value)
% [IN]
%        table : table data. (if table is not created, please set empty(=[]))
%    key_value : key-value data set(made by vb_key_value_pair.m)
% [OUT]
%        table : updated table data.
% [see]
%    vb_key_value_pair.m
%    vb_table_query_value.m
%
% [example]
%     tbl = [];
%     % create record
%     key = 'brain_file';
%     value = 'Cortical model file (.brain.mat)';
%     record = vb_key_value_pair(key, value);
%     % insert
%     tbl = vb_table_insert(tbl, record);
%     % inquery
%     value  = vb_table_query_value(tbl, key);
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('table', 'var')
    error('table is a required parameter.');
end
if ~exist('key_value', 'var')
    error('key_value is a required parameter.');
end
if ~isstruct(key_value) || ...
   ~isfield(key_value, 'key') || ~isfield(key_value, 'value')
    error('Unknown key_value type was specified.');
end

%
% --- Main Procedure
%
table = [table; key_value];

%
% --- After check
%
if nargout ~= 1
    error('You have to receive the updated table data.');
end
