function vb_struct2mscript(s, mfile, struct_name)
% Convert struct to file.
% [USAGE]
%    vb_struct2mscript(s, mfile [,struct_name])
% [IN]
%              s : <<struct>> structure.
%       filename : <<string>> mfile name.
%    struct_name : (opt) <<string>> struct name. 
%                    When 'inputname' function cannot detect the struct name.
%                    e.g.: vb_struct2_mscript(structarray{1}, mfile)
%                    Specify the 3rd argument.
%                    vb_struct2mscript(structarray{1}, mfile, 'structarray{1}');
% [OUT]
%    none
%
% [See also]
%    vb_struct2executable_str
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('s', 'var')
    error('Structure is not specified.');
end

%
% --- Main Procedure
%
if ~exist('struct_name', 'var')
    struct_name = inputname(1);
end
if isempty(struct_name)
    error('struct_name should be specified at 3rd argument.');
end
dlmwrite(mfile, vb_struct2executable_str(s, struct_name), 'delimiter', '');
