function vb_set_verbose(verbose_level)
% Put verbose level into VBMEG environment (global) variable 'vbmeg_inst'
%
% This function is used to control if messages in VBMEG are shown or
% not. It is noted that the verbose level is supported by vb_disp and
% other display functions (e.g., fprintf) is not affected with the
% verbose level. 
%
% [syntax]
% vb_set_verbose(verbose_level)
%
% [input]
% verbose_level: <<string>> Verbose level string
%   'NONE'      Suppressing all messages 
%   'EMERGENCY'
%   'WARNING'
%   'NOTICE'    VBMEG default value
%   'INFO'
%   'DEBUG'     Displaying all messages
%
% [example]
% >> vb_set_verbose('WARNING');
%
% [history]
% 2010-05-26 Taku Yoshioka
%
% [see also]
% vb_get_verbose, vb_disp
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst;
const = vb_define_verbose;

switch verbose_level
 case 'NONE'
  vbmeg_inst.verbose_level = const.VERBOSE_LEVEL_NONE;
 case 'EMERGENCY'
  vbmeg_inst.verbose_level = const.VERBOSE_LEVEL_EMERGENCY;
 case 'WARNING'
  vbmeg_inst.verbose_level = const.VERBOSE_LEVEL_WARNING;
 case 'NOTICE'
  vbmeg_inst.verbose_level = const.VERBOSE_LEVEL_NOTICE;
 case 'INFO'
  vbmeg_inst.verbose_level = const.VERBOSE_LEVEL_INFO;
 case 'DEBUG'
  vbmeg_inst.verbose_level = const.VERBOSE_LEVEL_DEBUG;
 otherwise
  error(['Undefined string for verbose level: ' verbose_level]);
end

