function	z = vb_repadd(x,y)
% MEX function to add a vector with a matrix without repmat 
% Much faster than using repmat and no need to memory allocation
% --- Usage
% z = vb_repadd(x,y)
% x : M x N
% z : M x N
%
% case  y : 1 x N
%  z = x + repmat(y, [M 1])
%  z(m,n) = x(m,n) + y(n)
%
% case  y : M x 1
%  z = x + repmat(y, [1 N])
%  z(m,n) = x(m,n) + y(m)
%
% case  y : 1 x 1
%  z = x + y
%  z(m,n) = x(m,n) + y
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
