function [m_struct] = vb_merge_struct(struct_a, struct_b)
% This function merges field of struct_a and struct_b,
% and return merged struct.
% [USAGE]
%    [m_struct] = vb_merge_struct(<struct_a>, <struct_b>);
% [IN]
%    struct_a : struct a
%    struct_b : struct b
% [OUT]
%    m_struct : merged struct
%
% Author: rhayashi
% Created: 2007-07-25
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('struct_a', 'var')
    error('struct_a is a required parameter.');
end
if ~exist('struct_b', 'var')
    error('struct_b is a required parameter.');
end

%
% --- Main Procedure
%
var_names_b = fieldnames(struct_b);
for k=1:length(var_names_b)
    struct_a.(var_names_b{k}) = struct_b.(var_names_b{k});
end
m_struct = struct_a;
