function	kld = vb_kl_distance(x,y)
% KL-distance of X and Y
% KL = vb_kl_distance(X,Y)
% X and Y are normalized before calculation 
% Zero value component is replaced by eps
%
% 2006-8-11 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

x = max(x,eps);
y = max(y,eps);

x = x/sum(x);
y = y/sum(y);

% KL-divergence
kld = sum( x.*log(x./y) ); 
