function vb_gobject_send_to_back(parent_h, handle)
% send graphics object back to the screen.
% [USAGE]
%    gobject_bring_to_back(<parent_h>, <handle>);
% [IN]
%    parent_h : figure or axes handle
%      handle : graphics object handle(s)
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('parent_h', 'var'), error('parent_h is a required parameter.'); end
if ~exist('handle', 'var')
    error('handle is a required parameter.');
end

%
% --- Main Procedure
%
h = get(parent_h, 'Children');
del_ix = [];
for k=1:length(handle)
    ix = find(h == handle(k));
    if ~isempty(ix)
        del_ix = [del_ix;ix];
    end
end

h(del_ix) = [];
new_h = [h; handle];
set(parent_h, 'Children', new_h);
