function	[pathname, filename] = ...
			vb_get_session_filename(datadir,basename,ext,session,mode)
% Get file names for specified directory 
%     with specified basename and extension
% --- Usage
%  [pathname, filename] = vb_get_session_filename(datadir,basename,ext)
%  [pathname, filename] = ...
%		vb_get_session_filename(datadir,basename,ext,session,mode)
% --- Input
% datadir : data directory name
%    ex.   'D:/data/eeg'
% basename : file basename
%    ex.   'SK' , ''
% ext : file extension
%    ex.   '.bdf'
% --- Optional Input
% session : session number list 
%   if session is given, filename is generated 
%   by using [datadir, basename, ext, session]
% mode : file name generation mode
% --- Output
% pathname : cell array of path for multiple files
%   pathname{n} = [datadir '/' filename{n} ext];
% filename : cell array of multiple file names without extension 'ext'
%   if session is given
%	  filename{n} = [basename, sprintf('_%d',  session(n))]; for mode=0
%	  filename{n} = [basename, sprintf('_%02d',session(n))]; for mode=1
%
% Masa-aki Sato 2008-08-14
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 3, error('Input arguments should be more than 3'); end;
if ~exist('session','var'), session = []; end;
if ~exist('mode','var'),mode=0;end

if isempty(session)
	dlist = dir([datadir '/' basename '*' ext]);
	Nfile = length(dlist);
	
	pathname = cell(1,Nfile);
	filename = cell(1,Nfile);
	
	for n=1:Nfile
		fname = dlist(n).name;
		y = findstr(fname,ext);
		filename{n} = fname(1:y(1)-1);
		
		pathname{n} = [datadir '/' fname];
	end
	
	return
end

Nsession = length(session);

pathname = cell(1,Nsession);
filename = cell(1,Nsession);

for n=1:Nsession
	if mode==0
		filename{n} = [basename, sprintf('_%d',session(n))];
	else
		filename{n} = [basename, sprintf('_%02d',session(n))];
	end
	
	if isempty(datadir)
		pathname{n} = [filename{n} ext];
	else
		pathname{n} = [datadir '/' filename{n} ext];
	end
end

return
