function	[fpath, fname] = vb_get_ext_fname(dname,ext,prefix)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin==1, ext = ''; end;
if nargin < 3, prefix = ''; end;

df = dir([dname '/*' ext]);

fpath = [];
fname = [];
Nfile = length(df);
nf = 0;

for n=1:Nfile
	if df(n).isdir==0,
		fn = df(n).name;
		if isempty(prefix) || any(strfind(fn,prefix) == 1),
			nf = nf + 1;
			fpath{nf} = [dname filesep fn];
			if ~isempty(ext),
				fn = fn(1:strfind(fn,ext)-1);
			end
			fname{nf} = fn;
		end
	end
end
