function bexp_new = vb_corr_base(parm)
% Baseline correction (for VBMEG version 0.5)
%
% --- Syntax
% vb_corr_base(parm)
%
% --- Input
% parm.bexp      : MEG time course
% parm.Twin      : Time window for 
%
% --- Note
% Temporal mean of signal within the temporal window is subtracted
% from corresponding sensor. 
%
% --- Example
% >> parm.Twin = [1 100]; % in sampling frame
% >> parm.bexp = vb_load_meg_data(megfile)
% >> bexp_new = vb_corr_base(parm);
%
% --- History
% Taku Yoshioka 2007-01-12
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

bexp_new = zeros(size(parm.bexp));
T = size(parm.bexp,2);

for i=1:size(parm.bexp,3)
  tmp = parm.bexp(:,parm.Twin(1):parm.Twin(2),i);
  tmp = mean(tmp')';
  bexp_new(:,:,i) = parm.bexp(:,:,i)-repmat(tmp,[1 T]);
end

