function	[fname ,basename, fext] = vb_change_file_basename(fold, addname, ext0)
% change basename of file for predefined extension
%  [fname ,basename, ext] = vb_change_file_basename(fold, addname)
%  [fname ,basename, ext] = vb_change_file_basename(fold, addname, ext)
% --- Input
% fold    : old file name = [ old_basename  extension ]
% addname : this string is added to the basename of the file name
% --- Optional input
% ext     : extension
%    If this variable is not specified, 
%    predefined extensions is used
% --- Output
% basename = [ old_basename  addname ]
% fname    : new file name = [ basename  extension ]
% ext      : extension
% --- Predefined extensions
%  '.brain.mat';
%  '.area.mat';
%  '.act.mat';
%  '.basis.mat';
%  '.meg.mat';
%  '.bayes.mat';
%  '.curr.mat' ;
%  '.xyz.mat';
%  '.atlas.mat';
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if exist('ext0','var'),
	ext{1} = ext0;
else
	ext{1} = '.brain.mat';
	ext{2} = '.area.mat';
	ext{3} = '.act.mat';
	ext{4} = '.basis.mat';
	ext{5} = '.meg.mat';
	ext{6} = '.bayes.mat';
	ext{7} = '.curr.mat' ;
	ext{8} = '.xyz.mat';
	ext{9} = '.atlas.mat';
end

Next   = length(ext);

for n = 1:Next
	fext   = ext{n};
	ix_ext = findstr(fold, fext);

	if ~isempty(ix_ext),
		basename = fold(1:ix_ext-1);
		basename = [basename addname];
		fname = [ basename fext];
		return
	end
end

% No match
fname = fold;
basename = [];
fext = [];
