function [obj, pop_data] = vb_m_stack_pop(obj)
% pop data from memory stack
% [USAGE]
%    [obj, pop_data] = vb_m_stack_pop(<obj>);
% [IN]
%    obj : m_stack object.
% [OUT]
%           obj : m_stack object.
%    pop_data : pop data from m_stack.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
pop_data = [];
last_ix = length(obj.queue);
if last_ix ~= 0
    pop_data = obj.queue(last_ix);
    % delete pop data
    obj.queue(last_ix) = [];
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive obj.');
end
