function this = set(this, varargin)
% file_dialog饹set᥽å
% setꤷ֥Ȥ˥ץѥƥͤꤷfile_dialog饹֤
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

property_argin = varargin;
while length(property_argin) >= 2,
  prop = property_argin{1};
  val = property_argin{2};
  property_argin = property_argin(3:end);

  if isfield( this.public, lower(prop) )
    [val, errmsg] = feval( sprintf('set_%s', lower(prop)), prop, val );

    if ~isempty(errmsg)
      error( errmsg );
    else	
      this.public = setfield(this.public, lower(prop), val);
    end
  else
      error( sprintf('Invalid properties: ''%s''', prop) )
  end
end
% End of 'function this = set(this, varargin)'

function [filter_str, errmsg] = set_filter_str(prop, val)
% եʤߥե륿ʸset᥽å
errmsg = [];
filter_str = [];
if ~ischar(val)
  errmsg = sprintf('''%s'':Value must be char array.', prop);
else
  filter_str = val;
end 
% End of 'function [filter_str, errmsg] = set_filter_str(prop, val)

function [save_mode, errmsg] = set_save_mode(prop, val)
% file_dialog饹save_mode֥ȤФset᥽å
% Ͱʳϼդʤ

save_mode = [];
errmsg = [];
if exist('true','builtin')
  if val == true	val = 1;
  elseif val == false	val = 0;
  end
end
if isnumeric(val)
  if val	save_mode = 1;
  else		save_mode = 0;
  end
else	errmsg = sprintf('''%s'':Value must be numeric.',prop);
end
% End of 'function [save_mode, errmsg] = set_save_mode(prop, val)'

function [dialog_title, errmsg] = set_dialog_title(prop, val)
% file_dialog饹dialog_titleФset᥽å
% ʸʳϼդʤ

dialog_title = [];
errmsg = [];

if ~ischar(val)
  errmsg = sprintf('''%s'':Value must be char array.', prop);
else
  dialog_title = val;
end
% End of 'function [dialog_title, errmsg] = set_dialog_title(prop, val)'

function [file_extensions, errmsg] = set_file_extensions(prop, val)
% file_dialog饹file_extensions֥ȤФset᥽å
% ʸcellʳϼդʤ

file_extensions = [];
errmsg = [];
if ~iscell(val)
  errmsg = sprintf('''%s'':Value must be cell array.',prop);
else
  for ii=1:length(val)
    if ~isstr(val{ii})
      errmsg = sprintf('''%s'':Value must be string.(val{%d})',prop, ii);
    end
  end
  file_extensions = val;
end
% End of 'function [file_extensions, errmsg] = set_file_extensions(prop, val)'


function [current_dir, errmsg] = set_current_dir(prop, val)
% file_dialog饹current_dir֥ȤФset᥽å
% ʸʳϼդʤ

current_dir = [];
errmsg = [];

if ~isstr(val)
  errmsg = sprintf('''%s'':Value must be string.',prop);
else	current_dir = val;
end
% End of 'function [current_dir, errmsg] = set_current_dir(prop, val)'


function [hist_dir, errmsg] = set_hist_dir(prop, val)
% file_dialog饹hist_dir֥ȤФset᥽å
% ʸcellʳϼդʤ

hist_dir = [];
errmsg = [];
if ~iscell(val)
  errmsg = sprintf('''%s'':Value must be cell array.',prop);
else
  for ii=1:length(val)
    if ~isstr(val{ii})
      errmsg = sprintf('''%s'':Value must be string.(val{%d})',prop, ii);
    end
  end
  hist_dir = val;
end
% End of 'function [hist_dir, errmsg] = set_hist_dir(prop, val)'


function [dialog_color, errmsg] = set_dialog_color(prop, val)
[dialog_color, errmsg] = set_gui_color(prop, val);
% End of 'function [dialog_color, errmsg] = set_dialog_color(prop, val)'


function [bgcol_panel, errmsg] = set_bgcol_panel(prop, val)
[bgcol_panel, errmsg] = set_gui_color(prop, val);
% End of 'function [bgcol_panel, errmsg] = set_bgcol_panel(prop, val)'


function [fgcol_panel, errmsg] = set_fgcol_panel(prop, val)
[fgcol_panel, errmsg] = set_gui_color(prop, val);
% End of 'function [fgcol_panel, errmsg] = set_fgcol_panel(prop, val)'


function [fgcol_text, errmsg] = set_fgcol_text(prop, val)
[fgcol_text, errmsg] = set_gui_color(prop, val);
% End of 'function [fgcol_text, errmsg] = set_fgcol_text(prop, val)'


function [bgcol_popup, errmsg] = set_bgcol_popup(prop, val)
[bgcol_popup, errmsg] = set_gui_color(prop, val);
% End of 'function [bgcol_popup, errmsg] = set_bgcol_popup(prop, val)'


function [fgcol_popup, errmsg] = set_fgcol_popup(prop, val)
[fgcol_popup, errmsg] = set_gui_color(prop, val);
% End of 'function [fgcol_popup, errmsg] = set_fgcol_popup(prop, val)'


function [bgcol_listbox, errmsg] = set_bgcol_listbox(prop, val)
[bgcol_listbox, errmsg] = set_gui_color(prop, val);
% End of 'function [bgcol_listbox, errmsg] = set_bgcol_listbox(prop, val)'


function [fgcol_listbox, errmsg] = set_fgcol_listbox(prop, val)
[fgcol_listbox, errmsg] = set_gui_color(prop, val);
% End of 'function [fgcol_listbox, errmsg] = set_fgcol_listbox(prop, val)'


function [bgcol_edit, errmsg] = set_bgcol_edit(prop, val)
[bgcol_edit, errmsg] = set_gui_color(prop, val);
% End of 'function [bgcol_edit, errmsg] = set_bgcol_edit(prop, val)'


function [fgcol_edit, errmsg] = set_fgcol_edit(prop, val)
[fgcol_edit, errmsg] = set_gui_color(prop, val);
% End of 'function [fgcol_edit, errmsg] = set_fgcol_edit(prop, val)'


function [bgcol_push, errmsg] = set_bgcol_push(prop, val)
[bgcol_push, errmsg] = set_gui_color(prop, val);
% End of 'function [bgcol_push, errmsg] = set_bgcol_push(prop, val)'


function [fgcol_push, errmsg] = set_fgcol_push(prop, val)
[fgcol_push, errmsg] = set_gui_color(prop, val);
% End of 'function [fgcol_push, errmsg] = set_fgcol_push(prop, val)'


function [col, errmsg] = set_gui_color(prop, val)
% file_dialog饹color֥ȤФset᥽å
% ʳϼդʤ

col = [];
errmsg = [];

if ~isnumeric(val) | ~length(val) == 3
  errmsg = sprintf('''%s'':value must be a 3 element numeric vector.',prop);
elseif min(val)<0.0 & min(val)>1.0
  errmsg = sprintf('''%s'':value out of range 0.0 <= value <= 1.0.',prop);
else
  col = val;
end
% End of 'function [col, errmsg] = set_gui_color(prop, val)'