function [] = vb_save_brain_proj(parm, file_identifier)
% Brain menuproject file¸롣
% file_identifier > 0λϥǡե򥪡ץ󤷤Ƥ顢
% δؿcallδؿǥեopen/closeʤ
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% 2005-03-20 Modified by TY
%global	define
global vbmeg_inst; 
define = vbmeg_inst.const; 

if file_identifier == false	% project file򳫤
  if ~isempty( findstr(parm.file.brain, define.BRAIN_EXTENSION) )
    BRAINfile =...
	parm.file.brain(1:findstr(parm.file.brain, define.BRAIN_EXTENSION)-1);
  else
    BRAINfile = parm.file.brain;
  end
  project_fname = [parm.dir.brain  BRAINfile define.BRAIN_PROJECT_EXTENSION];
  fd = fopen(project_fname, 'w');
else
  fd = file_identifier;
end


fprintf(fd, '# << Brain project datas >>\n');

% DICOM file (.tbl or .tbl.mat) Υե̾ȥǥ쥯ȥ̾¸롣
fprintf(fd, 'dir.mri = %s\n', parm.dir.mri);
fprintf(fd, 'file.dicom = %s\n', parm.file.dicom);

% Right-brain file (.srf) Υե̾ȥǥ쥯ȥ̾¸롣
fprintf(fd, 'dir.bvoy_right = %s\n', parm.dir.bvoy_right);
fprintf(fd, 'file.right = %s\n', parm.file.right);

% Left-brain file (.srf) Υե̾ȥǥ쥯ȥ̾¸롣
fprintf(fd, 'dir.bvoy_left = %s\n', parm.dir.bvoy_left);
fprintf(fd, 'file.left = %s\n', parm.file.left);

% Right-infrate file (.srf) Υե̾ȥǥ쥯ȥ̾¸롣
fprintf(fd, 'dir.inf_right = %s\n', parm.dir.right_inf);
fprintf(fd, 'file.inf_right = %s\n', parm.file.right_inf);

% Left-infrate file (.srf) Υե̾ȥǥ쥯ȥ̾¸롣
fprintf(fd, 'dir.inf_left = %s\n', parm.dir.left_inf);
fprintf(fd, 'file.inf_left = %s\n', parm.file.left_inf);

% BRAIN file (.brain.mat) Υե̾ȥǥ쥯ȥ̾¸롣
fprintf(fd, 'dir.brain = %s\n', parm.dir.brain);
fprintf(fd, 'file.brain = %s\n', parm.file.brain);

% INFLATE file (.inflate.mat) Υե̾ȥǥ쥯ȥ̾¸롣
fprintf(fd, 'dir.inflate = %s\n', parm.dir.inflate);
fprintf(fd, 'file.inflate = %s\n', parm.file.inflate);

% AREA file (.area.mat) Υե̾ȥǥ쥯ȥ̾¸롣
fprintf(fd, 'dir.area = %s\n', parm.dir.area);
fprintf(fd, 'file.area = %s\n', parm.file.area);

% FMRI file (.act.mat) Υե̾ȥǥ쥯ȥ̾¸롣
fprintf(fd, 'dir.act = %s\n', parm.dir.act);
fprintf(fd, 'file.act = %s\n', parm.file.act);

% keywordcomment¸롣
fprintf(fd, 'brain_parm.brain_keyword = %s\n', parm.brain_parm.brain_keyword);
fprintf(fd, 'brain_parm.brain_comment = %s\n', parm.brain_parm.brain_comment);



% ˵õκõȾ [m]
fprintf(fd, 'brain_parm.Rmax = %.10f\n', parm.brain_parm.Rmax);

% Ignore offset of MRI image
fprintf(fd, 'brain_parm.ignore_offset = %.10f\n',...
    parm.brain_parm.ignore_offset);

% Brain-Voyager ǡְȤΨ¸롣
fprintf(fd, 'brain_parm.Reduce_ratio = %.10f\n', parm.brain_parm.Reduce_ratio);

% Brain-VoyagerǥǾǥбõZʬ
fprintf(fd, 'brain_parm.Nstep = %d\n', parm.brain_parm.Nstep);

% ˵õη׻в򤳤ΥǡȤɽ
fprintf(fd, 'brain_parm.Display = %d\n', parm.brain_parm.Display);

if ~file_identifier	fclose(fd);	end

