function	normal_stat = vb_load_normal_statics(brainfile, coord_type)
% load original BV brain normal information
%  normal_stat = vb_load_normal_statics(brainfile[,coord_type])
% --- Input
%    brainfile : VBMEG BRAIN-MAT file(.brain.mat)
%   coord_type : = 'subj' : subject cortex normal is loaded. 
%                = 'std'  : standard cortex normal is loaded.
% --- Output
%   normal_stat.neighbor_org : original brain neighbor index list
%   normal_stat.normal_org   : original brain normal vector
%
% M. Sato  2006-7-23
%
% [Note]
%   BRAIN-MAT ver1: 'normal_stat' in root is individual subject normal_stat.
%   BRAIN-MAT ver2: 'normal_stat' in root is standard brain normal_stat.
%                   'subj.normal_stat' is individual subject normal_stat.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('coord_type', 'var')
    coord_type = 'subj';
end

warning('off', 'MATLAB:load:variableNotFound');
load(brainfile, 'subj');
warning('on',  'MATLAB:load:variableNotFound');

switch(lower(coord_type))
    case 'subj'
        if exist('subj', 'var')
            % V2 format
            normal_stat = subj.normal_stat;
        else
            % V1 format
            load(brainfile, 'normal_stat');
        end
    case 'std'
        if exist('subj', 'var')
            % V2 format
            load(brainfile, 'normal_stat');
        else
            % V1 format
            error('not contain standard normal info.');
        end
    otherwise
        error('Unknown coord type was specified : %s', coord_type);
end

if ~exist('normal_stat','var'), 
	error(['Their is no normal statics in ' brainfile]); 
end;

