function [Zact,ix_act] = ...
			vb_load_current_z(currfile,curr_type,ave_mode,trial,ix_area);
% load estimated current
%
% USAGE:
%  [Jact,ix_act] = ...
%			vb_load_current_z(currfile,curr_type,ave_mode,trial,ix_area);
%
% --- INPUT:
%  currfile  - current file name
% --- Optional INPUT:
%  curr_type - current type 
%            = 0 : J-current : original vertex current [Default]
%            = 1 : Z-current : internal current 
%                              correspond to locally spread source
%     If currfile is old format, curr_type is neglected
%     and Jact is returned
%  ave_mode : trial average mode
%          = ON  : trial average is done
%          = OFF : No trial average
%  trial   : trial number to load 
%            if empty, all trials are loaded
%  ix_area : (absolute) vertex index to load
%            if empty, all vertices are loaded
% --- OUTPUT:
% ix_act  : Vertex index corresponding to current
% Jact    : current in focal region
%   Jact(Nact,Nsample)          for ave_mode = ON 
%   Jact(Nact,Nsample,Ntrials)  for ave_mode = OFF
%     Nact     = Lact * Nvact,  Nvact = length(ix_act)
%     Nsample  : # of time sample, 
%     Ntrials  : # of trials in all session]
%
%   Jact( n + Nvact*(i-1), t, :) 
%    current at the vertex 'ix_act(n)', 'i-th' direction, time index 't'
%
%   Time sample in MEG data : t_meg = Tsample(t)
%   Time (ms)   in MEG data : t_ms  = (t_meg - Pretrigger)*(1000/SampleFreq)
%
%
% 2007-3-5 Masa-aki Sato
% 2008-7-9 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('curr_type','var'), curr_type = 0; end;
if ~exist('ave_mode','var'), ave_mode = ON; end;
if ~exist('trial','var'), trial = []; end;
if ~exist('ix_area','var'), ix_area = []; end;

load(currfile)

if ~exist('Zact','var') 
	error(['There is no Zact in ' currfile])
end

[NJ, T, Ntrial] = size(Zact);
if isempty(trial), trial = 1:Ntrial; end;

% find selected area index
if curr_type==0
	[ix_act_ex, jx_act_ex, ix_act, jx_act, Wact, Lact] = ...
      vb_current_area_info(Jinfo,ix_area);
else
	[ix_act, jx_act] = vb_current_area_info_z(Jinfo,ix_area);
end

Zact = Zact(jx_act,:,trial);

if ave_mode==ON,
	Zact = mean(Zact,3);
end

if curr_type==0
	Zact = vb_convert_current_j(Zact, Wact, Lact);
	ix_act = ix_act_ex; 
end

