function	[B, Vdim, Vsize] = vb_load_analyze_noflip(analyzefile)
% load analyze/nifti image without L-R flip
%  [B, Vdim, Vsize] = vb_load_analyze_noflip(analyzefile)
% --- Input
% analyzefile - Analyze/Nifti filename 
%               Default Analyze file is left-handed  LAS image
%               Default Nifti   file is Right-handed RAS image
% --- Output
% B     : 3D image data  [Xdim, Ydim, Zdim ]
% Vdim  : image size  [Xdim  Ydim  Zdim ] (voxels)
% Vsize : voxel size  [x y z ] (mm)
%
% written by M. Sato  2008-2-26
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% load analyze/nifti image file without flip orientation
avw = load_nii_cbi(analyzefile);

B = avw.img;

Vdim  = size(B);
Vsize = avw.hdr.dime.pixdim(2:4);

%try
%  % Faster than avw_img_read, but sometimes make error
%  [B, Vdim, Vsize] = read_image(analyzefile);
%  B = reshape(B,Vdim);
%catch
%  warning(['The "read_image" function output an error. '...
%	   'Try "avw_img_read" function']);
%  avw = avw_img_read(analyzefile);
%  B   = avw.img;
%  [Vdim, Vsize] = spm_hread(analyzefile);
%end
%
%return
%
%%&& DEBUG
%B1   = B1(Vdim(1):-1:1, :,:);
%errB = vb_err_array3d(B,B1)
%errD = Vdim  - Vdim1
%errS = Vsize - Vsize1
%%&& DEBUG
