function [V,F,C,Indx] = vb_fs_load_patch(patchfile,curvfile)
% ---
% function [V,C,Indx] = vb_fs_load_surface(patchfile,curvfile)
%
% Load patch file and original indices. 
%
% --- Input
% FS_index: FS indices in reduced cortical model (1-start)
%
% --- Output
% V       : Vertex coordinates
% F       : Faces
% C       : Curvature
% Indx    : Vertex index in the FS original model (1-start)
%
% 2006-02-01 Taku Yoshioka
% ---
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Load patch data
fid = fopen(patchfile,'r');
fgetl(fid); % Comment line
tmp = fscanf(fid,'%d %d',2);
NV = tmp(1); % Number of vertices
NF = tmp(2); % Number of patches

% Load vertices
V = [];
Indx = [];
for i=1:NV
  ix = fscanf(fid,'%d',1)+1; % Original vertex index
  Indx = [Indx; ix];
  tmp = fscanf(fid,'%e %e %e',3);
  V = [V; tmp']; 
end

% Load faces
F = [];
for i=1:NF
  fscanf(fid,'%d',1); 
  tmp = fscanf(fid,'%e %e %e',3)+1;
  ix1 = find(tmp(1)==Indx);
  ix2 = find(tmp(2)==Indx);
  ix3 = find(tmp(3)==Indx);
  F = [F; ix1 ix2 ix3];
end

fclose(fid);

% Load curvature data
n = load('-ascii',curvfile); % inner function
C = n(Indx,5);
C = (C./max(abs(C))+1)*0.5;
