function [V, F, C, Indx] = vb_fs_load_flat_patch(flatpatchfile, curvfile)
% function [V,C,Indx] = vb_fs_load_surface(patchfile,curvfile)
% Load flat patch file(lh/rh.flat.patch.3d.asc) and original indices. 
%
% [Input]
%   patchfile : Freesurfer flat patch file(lh/rh.flat.patch.3d.asc)
%
% [Output]
%    V       : Vertex coordinates
%    F       : Faces
%    C       : Curvature
%    Indx    : Vertex index in the FS original model (1-start)
%
% [History]
%    2018-8-02 rhayashi
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[N0,C] = vb_fs_load_normal(curvfile);

  
% Load patch data
fid = fopen(flatpatchfile,'r');
fgetl(fid); % Comment line
s = fgetl(fid);
tmp = sscanf(s,'%d %d',2);
NV = tmp(1); % Number of vertices
NF = tmp(2); % Number of patches

% Load vertices
V = zeros(size(N0, 1), 3);
%V(:, :) = nan;
Indx = zeros(NV, 1);

for k=1:NV
    s = fgetl(fid);
    ix = sscanf(s,'%d vno=%d', 2);
    s = fgetl(fid);
    tmp = sscanf(s,'%e %e %e',3);
%    fprintf('%d\n', k);
    Indx(k) = ix(2) + 1;
    V(Indx(k), :) = tmp';
end

% Load faces
F = zeros(NF, 3);
for k=1:NF
    s = fgetl(fid); % fno
    s = fgetl(fid); % F
    tmp = sscanf(s,'%e %e %e',3)+1;
    F(k, :) = [tmp'];
end
F = uint32(F);

fclose(fid);
% toc;
% % Load curvature data
% n = load('-ascii',curvfile); % inner function
% C = n(Indx,5);
% C = (C./max(abs(C))+1)*0.5;
