function Area_ = vb_get_area(areafile,key)
% This function is used to get cortical area data. 
%
% --- Syntax
% Area = vb_get_area(areafile,key)
%
% --- Input
% areafile: Cortical area file (.area.mat)
% key     : ID of cortical area data. 
%
% --- Optional Input
%
% --- Output
% Area.Iextract: Cortical area data (set of vertex indices). 
% Area.key     : ID of this data. 
%
% --- Example
% >> areafile = './TY/data/TY.area.mat';
% >> key = 'Cortex';
% >> Area = vb_get_area(areafile,key);
%
% --- History
% 2004-11-09 Taku Yoshioka
% 2006-8-23 M. Sato  If area is not found, [] is returned
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if exist(areafile) ~= 2
  error(['Area data file ''' areafile ''' is not found.']);
else
  load(areafile,'Area')
end

for i = 1:length(Area)
  if strcmp(Area{i}.key,key)
    Area_ = Area{i};
    return;
  end
end

Area_ = [];

disp(['Area data "' key '" is not found.']);

return


