function act = vb_get_act(actfile,key)
% This function is used to get cortical activity data. 
%
% --- Syntax
% act = vb_get_act(actfile,key)
%
% --- Input
% actfile: Cortical activity file (.act.mat)
% key    : ID of cortical activity data. 
%
% --- Optional Input
%
% --- Output
% act.xxP    : Activities for this cortical activity data. 
% act.key    : ID of this data. 
% act.comment: Comment on this data.
%
% --- Comment
% Activities are treated as nondimensional values, regard less of the
% source of the data (e.g., SPM t-value). The meaning of each of activity
% data should be managed by the user. 
%
% --- Example
% >> actfile = './TY/data/TY.act.mat';
% >> key = 'Uniform';
% >> act = vb_get_act(actfile,key);
%
% --- History
% 2004-11-09 Taku Yoshioka
% 2006-8-23 M. Sato  If area is not found, [] is returned
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

act = [];
if exist(actfile, 'file') ~= 2
  error('Activity map file is not found.');
else
  load(actfile,'Act');
end

for i = 1:length(Act)
  if strcmp(Act{i}.key,key)
    act = Act{i}; 
    return;
  end
end
disp(['Activity map ' key ' is not found.']);

return
