function	[Vindx, Iremove] = vb_remove_corpus_run(brainfile,Para)
%  Remove corpus region from cortex model
%  [Vindx, Iremove] = vb_remove_corpus_run(brainfile)
%
% Vindx   : Vertex index for cortex model after removing central region
% Iremove : Removed vertex index in central region
%
% Option input
% Para.Dmax_tri    : Max distance to find large triangle in corpus callosal
% Para.Rmax_remove : Max radius to extend remove region
% Para.Rerosion    : Radius for single erosion
%
% 2005-3-28  by M. Sato
%
% طʳưѤ˺ǾǾնĺĺǥå
%
% 
% ޤϤ Dmax 礭ĹĻѷ
%     濴նǾʬбĺ
% 
% RmaxϺǽΰ褫ɤΰ礵뤫Ⱦ
%     ˱äΥ16mm٤׻ƤʤΤǡ
%     Rmaxˤʤޤǥ򷫤֤
%     Rstep1Υ˻ѤȾ¡
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('brainfile','var')
	bayes_parm = set_bayes_parm_hand;
	brainfile = bayes_parm.brainfile;
end

%
% ----- Default Corpus Remove Parameter
%
if ~exist('Para','var') | ~isfield(Para,'Dmax_tri')
	% Max distance to find large triangle in corpus callosal
	Dmax_tri     = 0.02 ;
else
	Dmax_tri     = Para.Dmax_tri;
end	
if ~exist('Para','var') | ~isfield(Para,'Rmax_remove')
	% Max radius to extend remove region
	Rmax_remove  = 0.030;
else
	Rmax_remove  = Para.Rmax_remove;
end
if ~exist('Para','var') | ~isfield(Para,'Rerosion')
	% Radius for single erosion
	% erosion is repeated (Rmax/Rstep) times
	Rerosion     = 0.006;
else
	Rerosion     = Para.Rerosion;
end
if ~exist('Para','var') | ~isfield(Para,'Plot_mode')
	Plot_mode = 0;
else
	Plot_mode = Para.Plot_mode;
end
%
% ----- Remove corpus
[V, F] = vb_load_cortex(brainfile);
[nextDD,nextIX] = vb_load_cortex_neighbour(brainfile);

[Vindx, Iremove] = vb_remove_corpus(F,V,nextIX,nextDD, ...
                                 Rmax_remove, Rerosion, Dmax_tri);

if Plot_mode == 1,
	vb_plot_corpus( V,F,Iremove,Vindx );
end

return
