function [Jreduce,Vnew,Fnew,xx,Vinfo] = ...
              vb_reduce_cortex(brainfile,Jindx,Reduce_ratio);
% Make new cortex model with reduced resolution
%  [Jreduce,Vnew,Fnew] = vb_reduce_cortex(brainfile,Jindx,Reduce_ratio);
%
% --- Input
% brainfile
% Jindx    : vertex index for traget region
% Reduce_ratio = 1/Nrate : reduced ratio 
%  number of reduced vertex points become 1/Nrate
%
% --- Output
% Jreduce  : reduced vertex index in the original brain
% Vnew : vertex coordinate
% Fnew : patch index structure
%
% --- History
% Ver 1.1  by M. Sato  2003-4-15
% 2003-07-11 Modified by Taku Yoshioka
% 2004-3-28 Modified by M. Sato
% 2006-7-21 Modified by M. Sato
% 2008-11-28 Taku Yoshioka
%   Use vb_disp() for displaying message
% 2021-0-25 rhayashi
%   make IndxL,R value unique.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

const = vb_define_verbose;
VERBOSE_LEVEL_NOTICE = const.VERBOSE_LEVEL_NOTICE;

% ٤򲼤

% Ǿǥ
[V,F,xx] = vb_load_cortex(brainfile);  

% ĺɸ V 򺸱Ǿʬ
Ndipole  = size(V,1);
NdipoleL = F.NdipoleL ;

if ~exist('Jindx','var') | isempty(Jindx), Jindx = 1:Ndipole; end;
if ~exist('Reduce_ratio','var'), Reduce_ratio = 1/3; end;

V0L = V(1:NdipoleL , :);
V0R = V((NdipoleL+1):Ndipole , :);
F0R = F.F3R	;
F0L = F.F3L	;

%
% --- Redeuce patch
%
vb_disp('--- Reduce cortex',VERBOSE_LEVEL_NOTICE);
F0R = F0R - NdipoleL;
[F3L,V3L] = vb_reducepatch(F0L,V0L,Reduce_ratio); 
[F3R,V3R] = vb_reducepatch(F0R,V0R,Reduce_ratio);

%  ΤȤǾǥˤ륤ǥå
% ---  Find original vertex point to reduced model
%
IndxL = unique( vb_find_match_point(V0L,V3L,50 ) );
IndxR = unique( vb_find_match_point(V0R,V3R,50 ) + NdipoleL );

Jflag = zeros(Ndipole,1);	% Extract point flag
Jflag(Jindx) = 1;

ixL = find( Jflag(IndxL) > 0 );
ixR = find( Jflag(IndxR) > 0 );

% Index of reduced brain in the original brain
Jreduce = [ IndxL(ixL) ; IndxR(ixR)  ];

[V3L,F3L] = vb_trans_index( V3L, F3L, ixL);
[V3R,F3R] = vb_trans_index( V3R, F3R, ixR);

NL  = size(V3L,1);
F3R = F3R + NL;

Vnew = [V3L; V3R];

Fnew.F3L = F3L;
Fnew.F3R = F3R;
Fnew.F3  = [F3L; F3R ];

Fnew.NdipoleL = NL ;

xx = xx(Jreduce,:);

% Dimensional info
Vinfo.Ndipole   = size(Vnew, 1);
Vinfo.NdipoleL  = NL;
Vinfo.Npatch    = size(Fnew.F3, 1);
Vinfo.Coord     = 'SPM_Right_m';
