function	[xxD, xxF, xxT]= vb_next_distance2(F,V)
% Search next-point index and distance
%
% next_distanceȤΰ㤤Ϸ׻Υ1/1000ݤ뤳(mm->m)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ʬ٤κǶ˵ ( 3ѷͭ ) 򸫤Ĥ
% ֹ xxF  Υ xxD سǼ
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% xxF{n} : ĺ n  ܶ˵ĺֹ
% xxD{n} : ĺ n  ܶ˵ Ȥ Υ
% xxT{n} : ĺ n  ܣֹ
%
% Ver 1.0 written by M. Sato  2003-3-15
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Npoint = size(V,1);  		% number of dipoles
Npatch = size(F,1);  		% number of patch
xxF    = cell(Npoint,1); 
xxD    = cell(Npoint,1); 
xxT    = cell(Npoint,1); 

% ̤˴ؤ롼
for j=1:Npatch,
    % ̤ĺǥå
    k = F(j,:); 
    
    % ĺζ˵ꥹȤ¾ĺä
	xxF{k(1)} = [ xxF{k(1)} ; k(2) ; k(3)];
	xxF{k(2)} = [ xxF{k(2)} ; k(3) ; k(1)];
	xxF{k(3)} = [ xxF{k(3)} ; k(1) ; k(2)];
	
    % ĺΣ̥ꥹȤˣֹä
	xxT{k(1)} = [ xxT{k(1)} ; j ];
	xxT{k(2)} = [ xxT{k(2)} ; j ];
	xxT{k(3)} = [ xxT{k(3)} ; j ];
end;

for i=1:Npoint,

	% ˵ꥹȤνʣ
	nextix = unique(xxF{i});
	xxF{i} = nextix;
	Nnext  = length(nextix);
	
	% vector from vertex i to next points xxF{i}
	dd	   = V(nextix,:) - repmat( V(i,:) , Nnext , 1);
	
	% Distance from vertex i to next points xxF{i}
	xxD{i} = sqrt(dd(:,1).^2+dd(:,2).^2+dd(:,3).^2).*1e-3;
end
