function vb_make_flat_data(parm)
% ---
% function vb_make_flat_data(parm)
%
% Incorporate flat map of Brain Voyager. These data are
% associated with the brain surface data (.srf) from which 
% flat map are created. This function needs .brain.mat file,
% created based on the brain surface data, to make correspondence 
% of vertices between the original brain and flat map. 
% Variables 'IndxL' and 'IndxR' in .brain.mat file are used to make
% correspondence, i.e., reduction of vertices from the brain
% surface data to VBMEG brain data (.brain.mat). 
%
% Input parameters: 
% parm.[dir/file].brain     : VBMEG brain model (.brain.mat)
% parm.dir.bvoy_[left/right]: BV flat map directories
% parm.file.[left/right]_inf: BV flat map files
% parm.[dir/file].inflate   : flat model file. 
% parm.flat_cut_coeff       : (Optional) Remove patche if the
%                             maximum length of the side of the 
%                             patch is greater than flat_cut_coeff 
%                             times the median of maximum length 
%                             of all patches. 
% parm.areafile             : (Optional) Area data 'Cortex_flat',
%                             which consists of vertices included
%                             in patches of flat map, is registered
%                             to the area file specified by this
%                             parameter. 
%
% 2005-02-15 Taku Yoshioka
% ---
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~isfield(parm,'flat_cut_coeff')
  parm.flat_cut_coeff = 4;
end

dir   = parm.dir ;
file  = parm.file;

tic;
fprintf('--- Make Flat model \n');

%
% --- Brain-Voyager coordinate
%
% V0L/R  X:front(0)->back(255), Y:Top(0)->Bottom(255) , Z:left(0)->right(255)
% FOL/R  triangle patch

Srf    = vb_ScriptLoadSRF([dir.bvoy_left  file.left_inf]);

V0L    = [Srf.VertexX, Srf.VertexY, Srf.VertexZ]; 
F0L    = Srf.Triangles+1;
LColor = Srf.MeshColor;

Srf    = vb_ScriptLoadSRF([dir.bvoy_right  file.right_inf]);

V0R    = [Srf.VertexX, Srf.VertexY, Srf.VertexZ]; 
F0R    = Srf.Triangles+1;
RColor = Srf.MeshColor;

%save([dir.brain 'BVinf-' file.brain], ...
%	'V0L','V0R','F0L','F0R','LColor','RColor');

clear Srf F0L F0R

%
%  	   x:(-)->(+), y:(-)->(+), z:(-)->(+)

%V2L(:,1) = -V0L(:,3);
V2L(:,1) =  V0L(:,1);
V2L(:,2) =  V0L(:,3);
V2L(:,3) = -V0L(:,2);

%V2R(:,1) = -V0R(:,3);
V2R(:,1) = -V0R(:,1);
V2R(:,2) =  V0R(:,3);
V2R(:,3) = -V0R(:,2);

V2L = V2L./max(abs([V2L(:); V2R(:)]));
V2R = V2R./max(abs([V2L(:); V2R(:)]));
V2L(:,1) = V2L(:,1)+min(V2L(:,1));
V2R(:,1) = V2R(:,1)-max(V2R(:,1));
V2L(:,1) = V2L(:,1)+0.1*max(abs([V2L(:,1); V2R(:,1)]));
V2R(:,1) = V2R(:,1)-0.1*max(abs([V2L(:,1); V2R(:,1)]));

%
% --- redeuce patchs
%
%load([dir.brain  file.brain], 'F','IndxL','IndxR','MRI_ID','xxA');
load([dir.brain file.brain],'F','IndxL','IndxR','xxA');

%if ~strncmp( file.dicom , MRI_ID , 7 ), % compare first 7 character
%  fprintf('!! MRI_ID does not match\n');
%  return;
%end;

inf_V3L = V2L(IndxL,:);
inf_V3R = V2R(IndxR,:);
inf_LC	= LColor(IndxL,:);
inf_RC	= RColor(IndxR,:);
V	= [inf_V3L ; inf_V3R];   
inf_C	= [inf_LC  ; inf_RC ];

% Calculate patch size
V1L = V(F.F3L(:,1),:);
V2L = V(F.F3L(:,2),:);
V3L = V(F.F3L(:,3),:);
V1R = V(F.F3R(:,1),:);
V2R = V(F.F3R(:,2),:);
V3R = V(F.F3R(:,3),:);
sL = max([sqrt(sum((V2L-V1L).^2,2)) sqrt(sum((V3L-V2L).^2,2)) ...
	  sqrt(sum((V1L-V3L).^2,2))],[],2);
sR = max([sqrt(sum((V2R-V1R).^2,2)) sqrt(sum((V3R-V2R).^2,2)) ...
	  sqrt(sum((V1R-V3R).^2,2))],[],2);
%sL = abs(0.5*(sum((V2L-V1L).*(V3L-V1L),2)));
%sR = abs(0.5*(sum((V2R-V1R).*(V3R-V1R),2)));

% Remove large patch
ixL = find(sL < parm.flat_cut_coeff * median([sL; sR]));
ixR = find(sR < parm.flat_cut_coeff * median([sL; sR]));

%ixLv = find(inf_LC<0);
%ixRv = find(inf_RC<0)+length(inf_LC);
%ixL = find(ismember(F.F3L(:,1),ixLv) | ismember(F.F3L(:,2),ixLv) ...
%	   | ismember(F.F3L(:,3),ixLv));
%ixR = find(ismember(F.F3R(:,1),ixRv) | ismember(F.F3R(:,2),ixRv) ...
%	   | ismember(F.F3R(:,3),ixRv));
%ixL = setxor(1:size(F.F3L,1),ixL);
%ixR = setxor(1:size(F.F3R,1),ixR);

F.F3L = F.F3L(ixL,:);
F.F3R = F.F3R(ixR,:);
F.F3 = [F.F3L; F.F3R];

%
% --- save the brain model
%

% ĥ '.mat' 
if ~isempty( findstr(file.brain, '.mat') )
  BRAINfile = file.brain(1:findstr(file.brain, '.mat')-1);
else
  BRAINfile = file.brain;
end

fprintf(['--- Save flat model (' file.inflate ')\n']);
vb_fsave([dir.inflate file.inflate],'F','V','inf_C','xxA');

% Register area file
if isfield(parm,'areafile'), 
  area_new.Iextract = unique(F.F3(:));
  area_new.key = 'Cortex_flat';
  vb_add_area(parm.areafile,area_new);
end

