function [nextID, nextDD] = vb_find_neighbor(Rmax, Pindx, xxF, xxD )
% find neighbor
%   [nextID, nextDD] = vb_find_neighbor(Rmax, Pindx, xxF, xxD )
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ܶ˵ꥹ( xxF ) ȤεΥ( xxD ) Ȥä
% ˱ä¬äΥꤵ줿Ⱦ°ˤõ
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUT
%   Rmax	: Ⱦ
%   Pindx	: 濴Υǥå
%   xxF{i}  : ܶ˵ǥå
%   xxD{i}  : ܶ˵Υ
% OUTPUT
%   nextID  : ˵ǥå
%   nextDD	: ˵Υ
%
% Made by Masa-aki Sato on 2003/4/28
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 르ꥺ  Ƕ˵ꥹȤѤ Tree õ
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%ʬȤ롼Ȥˤ
%ƥ롼ܶ˵νꥹȤϿ
%ꥹȤǤޤǤ˻ƤʤФ
%ȯޤǤѵΥ׻(ϩ˰¸)
%ȯޤǤκûѵΥ
%ѵΥȾ°ˤ򸫤Ĥ
%嵭򿷤롼Ȥˤƣ
%Ⱦ°ˤ뿷롼Ȥ̵ʤäȤ˽λ

nextID  = Pindx; 	% ˵ǥåꥹ
nextDD	= 0;		% ˵ѵΥꥹ
rootix	= Pindx;  	% 롼ȤΥǥåꥹ
rootd	= 0;  		% 롼ȤѵΥꥹ
itree	= 0;  		% tree number

while itree==0 | ~isempty(rootix),  
    itree	 = itree+1;
    nroot	 = size(rootix,1); % Υ롼
    
    %  : ƤΥ롼Ȥܶ˵
    ixlist = []; % ܶ˵ǥåꥹ
    ddlist = []; % ܶ˵ؤѵΥꥹ
    
    for i=1:nroot, 
    	iroot  = rootix(i);	% 롼ȤΥǥå
	    ixlist = [ixlist; xxF{iroot}]; 				% ܶ˵ǥå
	    ddlist = [ddlist; xxD{iroot} + rootd(i) ];	% ܶ˵ؤѵΥ
    end;
    
    % ιʤ
    ixuniq = unique(ixlist);  			% ʣǥå
    nextix = vb_setdiff2(ixuniq,nextID);  	% õѤߤΥǥå

    % õǥå
    nextix = nextix(:);
    Nnext  = length(nextix);
    nextd  = zeros(Nnext,1);
    
    for i=1:Nnext,  % Loop of new dipoles
    	% ixlist  nextix(i) ǥå
        jx = find( nextix(i)==ixlist );
        
        % nextix(i) ؤκûѵΥõ
        nextd(i) = min(ddlist(jx)); 
    end
    
    % Ⱦ°θõ
    okix	= find(nextd<Rmax);  	% Ⱦ°θõ
    rootix	= nextix(okix);  		% Ⱦ°θ(Υ롼)
    rootd	= nextd(okix);  		% κûѵΥ

    % ˵ꥹ
    nextID = [nextID ; rootix ]; 	% ˵ꥹ
    nextDD = [nextDD ; rootd  ];  	% ûѵΥ
end
