function  [member_id] = vb_find_near_root(Vindx,nextIX,nextDD,Rmax)
% Find nearest root point for each vertex & make member list
%  [member_id] = vb_find_near_member(Vindx,nextIX,nextDD)
% --- Input
% nextIX{i} : Neighbor index list for the vertex-i
% nextDD{i} : Distance from the vertex-i
% Vindx     : Vertex index for root point
% Rmax      : Max radius for neighbor search
% --- Output
% member_id{n} : member vertex index which belog to the root point Vindx(n)
%
% M. Sato 2006-7-15
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Total number of vertex in the original brain
Nall  = length(nextDD);
Nroot = length(Vindx);

% Index transform table for root points
Itrans = zeros(Nall,1);
Itrans(Vindx) = 1:Nroot;

member_id = cell(Nroot,1);

for n=1:Nroot
	member_id{n} = Vindx(n);
end

Mindx = find( Itrans == 0 );

for m=1:length(Mindx)
	% neighbor distance & index
	n  = Mindx(m);
	dd = nextDD{n};
	id = nextIX{n};
	
	% find nearest root
	ix = find( Itrans(id) > 0 & dd > 0);
	[dmin, imin] = min(dd(ix));
	
	if isempty(imin) | dmin > Rmax , continue; end;
	
	% root index
	jj = id(ix(imin(1)));
	k  = Itrans(jj);
	member_id{k} = [member_id{k}, n];
end
