function  [member_id] = vb_find_near_member(xxF, xxD, Vindx, Rmax, Ndisp)
% Find member vertex near the root point & make member list
%  [member_id] = vb_find_near_member(xxF, xxD, Vindx, Rmax, Ndisp)
% --- Input
% xxF{i}  : Next-neighbor index that share the same triangle
% xxD{i}  : Distance between next-neighbor and the vertex-i
% Vindx   : Vertex index for root point
% Rmax    : Max radius for neighbor search
% Ndisp   : display process each Ndisp point
% --- Output
% member_id{n} : member vertex index which belog to the root point Vindx(n)
%
% [history]
% M. Sato 2006-7-15
% 2010-05-26 Taku Yoshioka
%  Minor change (verbose level support)
% 2011-06-20 taku-y
%  [minor] Progress message was added. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst;
verbose_const = vb_define_verbose;
if isempty(vbmeg_inst) | ~isfield(vbmeg_inst,'.verbose_level'), 
  verbose_level = verbose_const.VERBOSE_LEVEL_NOTICE;
else
  verbose_level = vbmeg_inst.verbose_level;
end

if ~exist('Ndisp','var'), Ndisp = 200; end;

% Total Vertex point number
Nall  = size(xxF,1);	
% Number of root points
Nroot = length(Vindx);
% Neighbor member list for root points
member_id = cell(Nroot,1);

% Add self index to member list 
for n=1:Nroot
	member_id{n} = Vindx(n);
end

Mcount = zeros(Nall,1);	% Number of root points near the vertex
Iroot  = cell(Nall,1);	% Root index list for each vertex
ddlist = cell(Nall,1);	% Distance list 

% progress
prg     = 0;
prg_all = Nroot;
h_prg   = waitbar(prg/prg_all,'Neighbor search');
vb_disp_nonl(sprintf('%3d %% processed',ceil(100*(prg/prg_all))));

% Make root index list for each vertex
for n=1:Nroot
  % neighbor distance & index
  [id, dd] = vb_find_neighbor(Rmax, Vindx(n), xxF, xxD );
	
  % root index list
  for m = 1:length(id)
    % Vertex index
    i = id(m);
    Mcount(i) = Mcount(i) + 1;
    % Add root index
    Iroot{i}  = [Iroot{i}, n];
    ddlist{i} = [ddlist{i}, dd(m)];
  end
  
  if mod(n,Ndisp)==0, 
    for ii=1:15; vb_disp_nonl(sprintf('\b')); end
    vb_disp_nonl(sprintf('%3d %% processed',ceil(100*(prg/prg_all))));
    waitbar(prg/prg_all,h_prg);
  end
  prg = prg+1;
end

vb_disp_nonl(' ');
close(h_prg);

% Exclude root index from root index list
Mcount(Vindx) = 0;

% one root point for one vertex
Indx = find( Mcount == 1 );

for m = 1:length(Indx)
  % Vertex index
  i = Indx(m);
  % Root index
  n = Iroot{i};
  member_id{n} = [member_id{n}, i];
end

% many root points for one vertex
Indx = find( Mcount > 1 );

for m = 1:length(Indx)
  % Vertex index
  i = Indx(m);
  % Root index list
  ix = Iroot{i};

  % find nearest root
  [dmin, imin] = min(ddlist{i});
	
  % Root index
  n = ix(imin(1));
  member_id{n} = [member_id{n}, i];
end

return;