function	[Vindex] = vb_extract_cortex(V0L,F0L,V0R,F0R,brain_parm,plot_mode)
% Extract cortex area index of original FreeSurfer surface
% 1. Load cortex area index from original FreeSurfer surface label file
% 2. Extract connected area of non-cortex region: corpus region
% 3. Get cortex area index (complement of non-cortex region)
%   [Vindex] = vb_extract_cortex(V0L,F0L,V0R,F0R,brain_parm)
% Vindex.cortexL = Left  cortex area index of original FreeSurfer surface
% Vindex.cortexR = Right cortex area index of original FreeSurfer surface
%
% 2015-12-27 M. Sato 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% FreeSurfer file
% brain_parm.FS_left_label_file  
% brain_parm.FS_right_label_file 

%brain_parm = vb_set_icbm152;
%[V0L,F0L,n0L,V0R,F0R,n0R] = vb_load_orig_brain_surf(brain_parm);

if ~exist('plot_mode', 'var')
    plot_mode = 0;
end

NL = size(V0L,1);
NR = size(V0R,1);
NV = NL + NR;

% Load cortex index
[VL,VLix] = load_cortex_label(brain_parm.FS_left_label_file);
[VR,VRix] = load_cortex_label(brain_parm.FS_right_label_file);

% get non-cortex index
flgL = zeros(NL,1);
flgR = zeros(NR,1);

flgL(VLix) = 1;
flgR(VRix) = 1;

izL = find(flgL == 0);
izR = find(flgR == 0);

% extract connected area of non-cortex region
[IZL] = vb_connected_vertex(izL,F0L);
[IZR] = vb_connected_vertex(izR,F0R);

izL = IZL{1};
izR = IZR{1};

% get cortex index
flgL = zeros(NL,1);
flgR = zeros(NR,1);

flgL(izL) = 1;
flgR(izR) = 1;

icL = find(flgL == 0);
icR = find(flgR == 0);

Vindex.cortexL = icL;
Vindex.cortexR = icR;
Vindex.corpusL = izL;
Vindex.corpusR = izR;

NCL = length(icL);
NCR = length(icR);
NZL = length(izL);
NZR = length(izR);

%NL = size(V0L,1);
%NR = size(V0R,1);

fprintf('N_original   = %d (left) %d (right)\n', NL,NR)
fprintf('N_cortex     = %d (left) %d (right)\n', NCL,NCR)
fprintf('N_non_cortex = %d (left) %d (right)\n', NZL,NZR)

if plot_mode == 0, return; end;

% plot
FLz = vb_patch_select(izL,F0L,NL);
FRz = vb_patch_select(izR,F0R,NR);

figure;
subplot(1,2,1)
vb_plot_surf(V0L,F0L,'','b')
hold on
vb_plot_surf(V0L,FLz,'r','r')

subplot(1,2,2)
vb_plot_surf(V0R,F0R,'','b')
hold on
vb_plot_surf(V0R,FRz,'r','r')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     load_cortex_label
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [V,Vix,Vlabel] = load_cortex_label(ascfile)

% Open file
fid = fopen(ascfile,'r');
fgetl(fid); % comment line

Num = fscanf(fid,'%d',1); 

% # of vertices
NV = Num(1);

% data list
data = fscanf(fid,'%d %e %e %e %e',inf);

fclose(fid);

%size(data)

V = reshape(data(1:NV*5),[5 NV])';

Vix = V(:,1) + 1; 
Vlabel = V(:,5); 
V = V(:,2:4); 
