function   [xxdev ,angl ]= ...
             vb_cortex_normal_variance(brainfile,areafile,area_key,...
                                       para, coord_type)
% average normal direction in the neighbor of vertex
%  [xxdev] = vb_cortex_normal_variance(brainfile,areafile,area_key,...
%                                      para, coord_type)
% --- Input
% brainfile
% areafile
% areakey
% coord_type : = 'subj' : subject cortex normal.  [default]
%              = 'std'  : standard cortex normal.
% --- Optional input
% para.tan_var : tangential variance coefficient
% para.var_max : tangential variance max
%
% In the brainfile, 'normal_stat' should be exist:
%   normal_stat.neighbor_org : original brain neighbor index list
%   normal_stat.normal_org   : original brain normal vector
% --- Output
% xxdev      : deviation from average normal vector  (NP x 3)
% xxdev(:,1) = variance ratio for average normal vector direction
% xxdev(:,2) = variance ratio for tangential direction
% xxdev(:,3) = variance ratio for tangential direction
%
% angl = Angle between neighboring normal vector and average normal vector
%
% M. Sato  2006-7-23
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% tangential variance coefficient
if exist('para','var') & isfield(para,'tan_var')
	tan_var = para.tan_var;
else
	tan_var = 1;
end
if ~exist('coord_type', 'var')
    coord_type = 'subj';
end

% tangential variance max
if exist('para','var') & isfield(para,'var_max')
	var_max = para.var_max;
else
	var_max = 2/3;
end

% tangential angle max
angle_max = pi/2;

normal_stat = vb_load_normal_statics(brainfile, coord_type);

%
% --- original vertex near the cortical vertex
%
% normal_stat.neighbor_org : original brain neighbor index list
% normal_stat.normal_org   : original brain normal vector

%
% --- Angle between neighboring normal vector and average normal vector
%
fprintf('--- Normal vector variance\n')
angl = vb_calc_normal_variance(normal_stat.neighbor_org,normal_stat.normal_org );

%
% select area
%
if exist('areafile','var') & exist('area_key','var') ...
      & ~isempty(areafile) & ~isempty(area_key),
	Area = vb_get_area([areafile], area_key);
	ix   = Area.Iextract;
	angl = angl(ix);
end

NP    = length(angl);
xxdev = zeros(NP,3);
tvar  = sin( min( tan_var * abs(angl), angle_max) );
tvar  = min( tvar, var_max );

xxdev(:,1) = 1;
xxdev(:,2) = tvar;
xxdev(:,3) = tvar;

xxn   = sum(xxdev,2);
xxdev = xxdev./repmat(xxn, [1 3]);
