function	vb_copy_std_brain(save_dir, Nvertex)
% Copy standard brain files to save_dir for group analysis
%
%  vb_copy_std_brain(save_dir, Nvertex)
%
% [history]
% Ver.2.0 New version for group analysis
% 2015-12-27 M. Sato 
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


% --- std_brain
[std_parm, proj_root] = vb_set_icbm152(Nvertex);

std_brain = [proj_root filesep std_parm.brain_file];
std_area  = [proj_root filesep std_parm.area_file];
std_act   = [proj_root filesep std_parm.act_file ];

std_area_aal  = [proj_root filesep std_parm.area_aal];
std_act_aal   = [proj_root filesep std_parm.act_aal ];
std_area_brd  = [proj_root filesep std_parm.area_brodmann];
std_act_brd   = [proj_root filesep std_parm.act_brodmann ];

std_id    = std_parm.std_id   ;
std_dir   = std_parm.std_dir   ;

std_image     = [std_dir std_id '.img'];
std_hdr       = [std_dir std_id '.hdr'];

% --- Copy of std_brain in save_dir
save_image     = [save_dir  '/std_copy.img'  ];
save_hdr       = [save_dir  '/std_copy.hdr'  ];

%save_brain_mni = [save_dir  '/std_mni.brain.mat'];  % V = Vmni
save_brain_spm = [save_dir  '/std_copy.brain.mat']; % V = Vspm

save_act       = [save_dir  '/std_copy.act.mat'  ];
save_area      = [save_dir  '/std_copy.area.mat' ];

save_act_aal   = [save_dir  '/std_copy_aal.act.mat'];
save_act_brd   = [save_dir  '/std_copy_brodmann.act.mat'];
save_area_aal  = [save_dir  '/std_copy_aal.area.mat'];
save_area_brd  = [save_dir  '/std_copy_brodmann.area.mat'];

% --- Copy file
if exist(std_image ,'file'), copyfile(std_image ,save_image  ); end;
if exist(std_hdr   ,'file'), copyfile(std_hdr   ,save_hdr    ); end;

%if exist(std_brain ,'file'), copyfile(std_brain ,save_brain_mni); end;
if exist(std_brain ,'file'), copyfile(std_brain ,save_brain_spm); end;

if exist(std_act   ,'file'), copyfile(std_act   ,save_act  ); end;
if exist(std_area  ,'file'), copyfile(std_area  ,save_area );end;

if exist(std_act_aal ,'file'), copyfile(std_act_aal ,save_act_aal); end;
if exist(std_act_brd ,'file'), copyfile(std_act_brd ,save_act_brd); end;
if exist(std_area_aal,'file'), copyfile(std_area_aal,save_area_aal);end;
if exist(std_area_brd,'file'), copyfile(std_area_brd,save_area_brd);end;

return
%
%% --- Save MNI [m] coordinate in std_brain as V
%V = vb_load_cortex(std_brain,'MNI');
%
%vb_save([save_brain_mni],'V');
