function	[xxA] = vb_calc_patch_area(V,F3,xxT)
% --- get area of patches
%  [xxA] = vb_calc_patch_area(V,F3,xxT)
%
% [history]
% 2010-05-28 Taku Yoshioka
%  Minor change (verbose level support)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

tic;
vb_disp_nonl('Patch area: ');

Npatch  = size(F3,1); 
Ndipole = size(V,1);
FA	    = zeros(Npatch,1);

for i=1:Npatch,
  xpl   = vb_cross2(V(F3(i,2),:)-V(F3(i,1),:), V(F3(i,3),:)-V(F3(i,1),:));
  FA(i) = sqrt(xpl*xpl')/2;      % patch area by cross product
end

ix = find(FA<eps);

if ~isempty(ix), 
  vb_disp('!! There are some abnormal areas '); 
  FA(ix)=0;
end

vb_disp_nonl(sprintf('%f[sec]\n',toc));

%
% --- Allocate area for each dipole
%
tic;
vb_disp_nonl('Allocate triangle area to each vertex: ');

xxA=zeros(Ndipole,1);

for i=1:Ndipole,
    rix    = xxT{i};
	xxA(i) = sum(FA(rix))/3;		% 1/3 of total triangle area
%	xxA(i) = sum(FA(rix))/length(rix);	% mean area
end    

