function	vb_act_to_reduce_brain(actfile, areafile, actkey, ...
                                 reducekey,reduced_actfile)
% acttivity map is transformed to act map in the reduced brain model
%   vb_act_to_reduce_brain(actfile, areafile, actkey)
%   vb_act_to_reduce_brain(actfile, areafile, actkey, reducekey,reduced_actfile)
% --- Input
%  actfile  = 'xxx.act.mat'
%  areafile = 'xxx.area.mat'
%  actkey
% --- Optional input
%  reducekey : area key to specify reduced brain model
%            = 'reduced_cortex' (Default)
%  reduced_actfile ; act file for reduced brain model
%            = 'xxx_reduced.act.mat' (Default)
% --- Output
% act index corresponding to actkey in the actfile
% is converted to the act index in the reduced brain model
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('reducekey','var'), reducekey   = 'reduced_cortex'; end;

Area  = vb_get_area(areafile,reducekey);

if isempty(Area), 
	fprintf('No reduced brain key : [%s] in [%s]\n',reducekey,areafile)
	return
end

Ixall = Area.Iextract;

if ~exist('reduced_actfile','var') | isempty(reduced_actfile),
	reduced_actfile = vb_change_file_basename(actfile, '_reduce');
end

act = vb_get_act(actfile, actkey);

if ~isempty(act)
	xxP0 = act.xxP;
	xxP  = xxP0(Ixall);
	act.xxP = xxP;
	vb_add_act([reduced_actfile], act);
else
	fprintf('No act key : [%s] in [%s]\n',actkey,actfile)
end
