% Get header of the system information
% [ Yokogawa MEG Reader optional toolbox for MATLAB ]
%
% brief:
%   This function retrieves information about calibration information in the specified file.
%
% usage:
%   calib = getYkgwHdrCalib(filepath)
%
% arguments:
%   filepath       : file path
%
% return values:
%  calib             : structure, The structure of calibration information.     
%    .sensitivity    : structure array The structure array of sensitivity corresponding to each channel 
%                     .sensitivity(1) corresponds to 'channel 0'     
%       .gain        : double, Sensor sensitivity [Tesla/Volt] @ fll.gain = 1      
%       .offset      : double, Sensor offset [Volt] @ fll.gain = 1
%                 
%    .fll            : structure array The structure array of FLL/ASP gain corresponding to each FLL unit      
%                     .fll(1) corresponds to 'unit 0'        
%       .gain        : double, FLL/ASP total gain      
%                 
%    .ad             : The structure array of A/D converter        
%      .bit          : double, A/D bit length      
%      .analog_range : double, Analog voltage range [Volt]     
%
% rivision history
%   0 : 2011.04.27 : first release
% 
% Copyright (C) 2011 Yokogawa Electric Corporation, All Rights Reserved.
