function	[brain_parm, proj_root] = vb_set_icbm152(Nvertex)
% Make Standard brain file.
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Pervious check
%
if nargin ~= 1
    error('Nvertex is a required parameter.');
end


global vbmeg_inst;

% ID for MNI-ICBM152
std_id = 'mni_icbm152_t1_tal_nlin_asym_09c';

std_file = vbmeg_inst.const.FILE_MNI_ICBM152_HDR;

std_dir   = vb_get_file_parts(std_file);
fs_dir    = fullfile(std_dir, 'FreeSurfer', std_id, 'private');

% brain dir
proj_root = fullfile(std_dir, ['mni_icbm152_t1_tal_nlin_asym_09c_', num2str(Nvertex)]);

% dirctory
brain_parm.std_id    = std_id;
brain_parm.std_dir   = std_dir;
brain_parm.fs_dir    = fs_dir;


% image file
brain_parm.analyze_file = fullfile(std_dir, [std_id '.hdr']);

% brain file
output_file = [std_id, '_', num2str(Nvertex)];
brain_parm.brain_file  = [output_file '.brain.mat'];
brain_parm.area_file     = [output_file '.area.mat' ];
brain_parm.act_file      = [output_file '.act.mat'  ];

brain_parm.area_aal      = [output_file '_aal.area.mat' ];
brain_parm.act_aal       = [output_file '_aal.act.mat'  ];

brain_parm.area_brodmann = [output_file '_brodmann.area.mat' ];
brain_parm.act_brodmann  = [output_file '_brodmann.act.mat'  ];

brain_parm.area_dktatlas = [output_file '_DKTatlas.area.mat' ];
brain_parm.act_dktatlas  = [output_file '_DKTatlas.act.mat'  ];

brain_parm.area_destrieux = [output_file '_Destrieux.area.mat' ];
brain_parm.act_destrieux  = [output_file '_Destrieux.act.mat'  ];

brain_parm.area_yeo2011_17networks = [output_file '_Yeo2011_17Networks.area.mat' ];
brain_parm.act_yeo2011_17networks  = [output_file '_Yeo2011_17Networks.act.mat'  ];

brain_parm.area_yeo2011_7networks = [output_file '_Yeo2011_7Networks.area.mat' ];
brain_parm.act_yeo2011_7networks  = [output_file '_Yeo2011_7Networks.act.mat'  ];

brain_parm.area_hc_mmp1 = [output_file '_HCP_MMP1.area.mat' ];
brain_parm.act_hc_mmp1  = [output_file '_HCP_MMP1.act.mat'  ];

% FreeSurfer file
brain_parm.FS_left_file         = [fs_dir '/bem/lh.smoothwm.asc'];
brain_parm.FS_right_file        = [fs_dir '/bem/rh.smoothwm.asc'];
brain_parm.FS_left_infl_file    = [fs_dir '/bem/lh.inflated.asc'];
brain_parm.FS_right_infl_file   = [fs_dir '/bem/rh.inflated.asc'];
brain_parm.FS_left_curv_file    = [fs_dir '/bem/lh.curv.asc'];
brain_parm.FS_right_curv_file   = [fs_dir '/bem/rh.curv.asc'];

brain_parm.FS_left_sphere_file  = [fs_dir '/bem/lh.sphere.reg.asc'];
brain_parm.FS_right_sphere_file = [fs_dir '/bem/rh.sphere.reg.asc'];

brain_parm.FS_left_label_file  = [fs_dir '/label/lh.cortex.label'];
brain_parm.FS_right_label_file = [fs_dir '/label/rh.cortex.label'];

brain_parm.FS_sphere_key = 'sphere.reg';


brain_parm.R_max = 0.018;
brain_parm.Nvertex = Nvertex;
brain_parm.N_step = 50;
brain_parm.display = 200;
brain_parm.keyword = '';
brain_parm.comment = '';
