function	[pick, Qpick, w] = sensor_pos_neuromag(MEGid,U)
% sensor position of neuromag
% [usage]
%
% [input]
%   MEGid : <required> MEG channel type. A type of this varible must be a
%            charactor string or integer as followed.
%            char)
%              'VV_PLANAR_T1' or 'VV_PLANAR_T2', 'VV_PLANER_T3'
%              'VV_MAG_T1' or 'VV_MAG_T2', 'VV_MAG_T3'
%              'Neuromag_122'
%            integer)
%               3012 or 3013 or 3014
%               3022 or 3023 or 3024
%               2
%       U : <required> transformation matrix [4 x 4]
% [output]
%    pick : coil position [n_coil x 3]
%   Qpick : coil direction [n_coil x 3]
%       w : 
% [note]
% [history]
%Masa-aki Sato 2009-4-13
%    M.Fukushima   2012/11/15
%      * modified to import Henson dataset
%    rhayashi      2013-9-9   Added support VV_MAG_T3, VV_PLANER_T3
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%fprintf('MEGid=')
if ischar(MEGid),
	switch	MEGid
	case	{'VV_PLANAR_T1','VV_PLANAR_T2','VV_PLANER_T3'}
		% 3012 : Vectorview type 1 planar gradiometer
		% 3013 : Vectorview type 2 planar gradiometer
		% ( +/-8.4 ,0.0 , 0.3 ) mm 
		% +/- 1/16.8mm
		
		% sensor position
		x1 = [  8.4 , 0.0 , 0.3]*0.001;
		x2 = [ -8.4 , 0.0 , 0.3]*0.001;
		z  = [  0.0 , 0.0 , 1.0];
		
		w     = [ 1/16.8 , -1/16.8]*1000;
		pick  = [x1, 1; x2, 1] * U(:,1:3);
		Qpick = [z; z] * U(1:3,1:3);
	%	fprintf('%d\n',MEGid)
	case	{'VV_MAG_T1','VV_MAG_T2'}
		% 3022 : Vectorview type 1 magnetometer
		% 3023 : Vectorview type 2 magnetometer
		% (6.45,6.45,0.3) mm 
		% 1/4
		
		% sensor position
		x1 = [  6.45 , 6.45 , 0.3]*0.001;
		x2 = [  6.45 ,-6.45 , 0.3]*0.001;
		x3 = [ -6.45 , 6.45 , 0.3]*0.001;
		x4 = [ -6.45 ,-6.45 , 0.3]*0.001;
		z  = [  0.0 , 0.0 , 1.0];
		
		w     = [ 1/4 ,1/4 ,1/4 ,1/4 ];
		pick  = [x1, 1; x2, 1; x3, 1; x4, 1] * U(:,1:3);
		Qpick = [z; z; z; z] * U(1:3,1:3);
	%	fprintf('%d\n',MEGid)
    case {'VV_MAG_T3'}
		% 3024 : Vectorview type 3 magnetometer
		% (5.25,5.25,0.3) mm 
		% 1/4
		
		% sensor position
		x1 = [  5.25 , 5.25 , 0.3]*0.001;
		x2 = [  5.25 ,-5.25 , 0.3]*0.001;
		x3 = [ -5.25 , 5.25 , 0.3]*0.001;
		x4 = [ -5.25 ,-5.25 , 0.3]*0.001;
		z  = [  0.0 , 0.0 , 1.0];
		
		w     = [ 1/4 ,1/4 ,1/4 ,1/4 ];
		pick  = [x1, 1; x2, 1; x3, 1; x4, 1] * U(:,1:3);
		Qpick = [z; z; z; z] * U(1:3,1:3);
	%	fprintf('%d\n',MEGid)
	case	{'Neuromag_122'}
		% 2 : Neuromag-122 : planar gradiometer
		% (8.1, 0, 0)mm
		% 1/16.2mm
		% 
		
		% sensor position
		x1 = [  8.1 , 0.0 , 0.0]*0.001;
		x2 = [ -8.1 , 0.0 , 0.0]*0.001;
		z  = [  0.0 , 0.0 , 1.0];
		
		w     = [ 1/16.2 , -1/16.2]*1000;
		pick  = [x1, 1; x2, 1] * U(:,1:3);
		Qpick = [z; z] * U(1:3,1:3);
	%	fprintf('%d\n',MEGid)
	otherwise
		w	  = [];
		pick  = [];
		Qpick = [];
	%	fprintf('\n')
	end
else
	switch	MEGid
	case	{3012,3013,3014}
		% 3012 : Vectorview type 1 planar gradiometer
		% 3013 : Vectorview type 2 planar gradiometer
		% 3014 : Vectorview type 3 planar gradiometer
		% ( +/-8.4 ,0.0 , 0.3 ) mm 
		% +/- 1/16.8mm
		
		% sensor position
		x1 = [  8.4 , 0.0 , 0.3]*0.001;
		x2 = [ -8.4 , 0.0 , 0.3]*0.001;
		z  = [  0.0 , 0.0 , 1.0];
		
		w     = [ 1/16.8 , -1/16.8]*1000;
		pick  = [x1, 1; x2, 1] * U(:,1:3);
		Qpick = [z; z] * U(1:3,1:3);
	%	fprintf('%d\n',MEGid)
	case	{3022,3023}
		% 3022 : Vectorview type 1 magnetometer
		% 3023 : Vectorview type 2 magnetometer
		% (6.45,6.45,0.3) mm 
		% 1/4
		
		% sensor position
		x1 = [  6.45 , 6.45 , 0.3]*0.001;
		x2 = [  6.45 ,-6.45 , 0.3]*0.001;
		x3 = [ -6.45 , 6.45 , 0.3]*0.001;
		x4 = [ -6.45 ,-6.45 , 0.3]*0.001;
		z  = [  0.0 , 0.0 , 1.0];
		
		w     = [ 1/4 ,1/4 ,1/4 ,1/4 ]; % fT
		pick  = [x1, 1; x2, 1; x3, 1; x4, 1] * U(:,1:3);
		Qpick = [z; z; z; z] * U(1:3,1:3);
	%	fprintf('%d\n',MEGid)
    case {3024}
		% 3024 : Vectorview type 3 magnetometer
		% (5.25,5.25,0.3) mm 
		% 1/4
		
		% sensor position
		x1 = [  5.25 , 5.25 , 0.3]*0.001;
		x2 = [  5.25 ,-5.25 , 0.3]*0.001;
		x3 = [ -5.25 , 5.25 , 0.3]*0.001;
		x4 = [ -5.25 ,-5.25 , 0.3]*0.001;
		z  = [  0.0 , 0.0 , 1.0];
		
		w     = [ 1/4 ,1/4 ,1/4 ,1/4 ]; % fT
		pick  = [x1, 1; x2, 1; x3, 1; x4, 1] * U(:,1:3);
		Qpick = [z; z; z; z] * U(1:3,1:3);
	%	fprintf('%d\n',MEGid)
	case	{2}
		% 2 : Neuromag-122 : planar gradiometer
		% (8.1, 0, 0)mm
		% 1/16.2mm
		% 
		
		% sensor position
		x1 = [  8.1 , 0.0 , 0.0]*0.001;
		x2 = [ -8.1 , 0.0 , 0.0]*0.001;
		z  = [  0.0 , 0.0 , 1.0];
		
		w     = [ 1/16.2 , -1/16.2]*1000;
		pick  = [x1, 1; x2, 1] * U(:,1:3);
		Qpick = [z; z] * U(1:3,1:3);
	otherwise
		w	  = [];
		pick  = [];
		Qpick = [];
	%	fprintf('\n')
	end
end
