function	[pick, Qpick] = sensor_center_neuromag(MEGid,U)
% center position of Vectorview type 1 planar gradiometer
%
% Masa-aki Sato 2009-4-13
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%fprintf('MEGid=')
if ischar(MEGid),
	switch	MEGid
	case	{'VV_PLANAR_T1','VV_PLANAR_T2','Neuromag-122'}
		% center position
		x  = [  0.0 , 0.0 , 0.0]*0.001;
		z  = [  0.0 , 0.0 , 1.0];
		
		pick  = [x, 1] * U(:,1:3);
		Qpick = [z] * U(1:3,1:3);
	otherwise
		pick  = [];
		Qpick = [];
	%	fprintf('\n')
	end
else
	switch	MEGid
	case	{3012,3013,3022,3023,2}
		x  = [  0.0 , 0.0 , 0.0]*0.001;
		z  = [  0.0 , 0.0 , 1.0];
		
		pick  = [x, 1] * U(:,1:3);
		Qpick = [z] * U(1:3,1:3);
	otherwise
		pick  = [];
		Qpick = [];
	%	fprintf('\n')
	end
end
