function [bexp, ch_info, sf] = neuromag_load_meg_data_SSP(fif_file, index_in_fiffile)
% load data with applying SSP(Signal-Space Projection) operation from fiffile.
% [USAGE]
%    [bexp] = neuromag_load_meg_data_withSSP(<fif_file>, <index_in_fif_file>);
% [IN]
%                  fif_file : fif file(Continuous file or Evoked file)
%          index_in_fiffile : = -1 : continuous
%                             =  N : read data set number in fiffile.
% [OUT]
%    bexp : The data of one channel in each row, a single time sample in
%           each column. Units: SI units. fT/m for gradiometers, fT for
%           magnetometers, V for electric channels.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fif_file', 'var')
    error('fif_file is a required parameter.');
end
if exist(fif_file, 'file') ~= 2
    error('fif_file:%s is not found.', fif_file);
end
if ~exist('index_in_fiffile', 'var')
    index_in_fiffile = -1; % continuous
end


%
% --- Main Procedure
%
ch_info = neuromag_load_ch_info(fif_file);

if index_in_fiffile == -1
    % load Continuous data
    raw = fiff_setup_read_raw(fif_file);
    for k=1:length(raw.info.projs)
        raw.info.projs(k).active = true;
    end
    proj = mne_make_projector_info(raw.info);
    raw.proj = proj;
    bexp = fiff_read_raw_segment(raw);
    sf  = raw.info.sfreq;
else
    % load Evoked data
    raw = fiff_read_evoked(fif_file, index_in_fiffile);
    bexp = raw.evoked.epochs;
    sf  = raw.info.sfreq;
end

meg_ix = [];
for k=1:ch_info.Nch
    channel_name = ch_info.channel_name(k, :);
    meg_ix = [meg_ix; strmatch(channel_name, raw.info.ch_names, 'exact')];
end
bexp = bexp(meg_ix, :, :);
