function [data, extra_info] = neuromag_load_extra_data(fiffile, index_in_fiffile)
% load extra channel data from fiffile.
% [USAGE]
%    [data] = neuromag_load_extra_data(<fiffile>);
% [IN]
%                   fiffile : fiffile(Continuous file or Evoked file)
%          index_in_fiffile : = -1 : continuous
%                             =  N : data set number in fiffile.
% [OUT]
%    data : The data of one channel in each row, a single time sample in
%           each column. Units: SI units. fT/m for gradiometers, fT for
%           magnetometers, V for electric channels.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('fiffile', 'var')
    error('fiffile is a required parameter.');
end
if exist(fiffile, 'file') ~= 2
    error('fiffile:%s is not found.', fiffile);
end
if ~exist('index_in_fiffile', 'var')
    index_in_fiffile = -1; % continuous
end


%
% --- Main Procedure
%
extra_info = neuromag_load_extra_info(fiffile);

if index_in_fiffile == -1
    % load Continuous data
    raw  = fiff_setup_read_raw(fiffile);
    data = fiff_read_raw_segment(raw);
else
    % load Evoked data
    raw  = fiff_read_evoked(fiffile, index_in_fiffile);
    data = raw.evoked.epochs;
end
    
extra_ix = [];
for k=1:length(extra_info.Channel_name)
    channel_name = extra_info.Channel_name{k};
    extra_ix = [extra_ix; strmatch(channel_name, raw.info.ch_names, 'exact')];
end
data = data(extra_ix, :, :);
